/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.collection;

import de.svws_nrw.core.adt.collection.LinkedCollectionDescendingIterator;
import de.svws_nrw.core.adt.collection.LinkedCollectionElement;
import de.svws_nrw.core.adt.collection.LinkedCollectionIterator;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LinkedCollection<@NotNull E>
implements Deque<E> {
    LinkedCollectionElement<@NotNull E> _head;
    LinkedCollectionElement<@NotNull E> _tail;
    private int _size;
    int _modCount;

    public LinkedCollection() {
        this._head = null;
        this._tail = null;
        this._size = 0;
        this._modCount = 0;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public LinkedCollection(LinkedCollection<? extends @NotNull E> c) {
        this._size = 0;
        this._modCount = 0;
        @NotNull Iterator<@NotNull E> iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        this._modCount = c._modCount;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._head == null;
    }

    @Override
    public boolean contains(Object obj) {
        if (this.isEmpty()) {
            return false;
        }
        @NotNull Iterator<@NotNull E> iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull E> iterator() {
        return new LinkedCollectionIterator(this);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        if (this._size == 0) {
            return new Object[0];
        }
        @NotNull Object @NotNull [] array = (Object[])Array.newInstance(this._head.getValue().getClass(), this._size);
        @NotNull Iterator<@NotNull E> iter = this.iterator();
        for (int i = 0; i < this._size; ++i) {
            array[i] = iter.next();
        }
        return array;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        if (a.length < this._size) {
            return this.toArray();
        }
        @NotNull Iterator<@NotNull E> iter = this.iterator();
        for (int i = 0; i < this._size; ++i) {
            @NotNull E e = iter.next();
            a[i] = e;
        }
        Arrays.fill(a, this._size, a.length, null);
        return a;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        @NotNull LinkedCollectionElement<@NotNull E> newElem = new LinkedCollectionElement<E>(e, null, null);
        if (this._head == null || this._tail == null) {
            this._head = newElem;
            this._tail = newElem;
            ++this._size;
            ++this._modCount;
            return true;
        }
        newElem.setPrev(this._tail);
        this._tail.setNext(newElem);
        this._tail = newElem;
        ++this._size;
        ++this._modCount;
        return true;
    }

    private boolean removeElement(LinkedCollectionElement<@NotNull E> elem) {
        if (elem == null) {
            return false;
        }
        LinkedCollectionElement<@NotNull E> prev = elem.getPrev();
        LinkedCollectionElement<@NotNull E> next = elem.getNext();
        if (this._size == 1) {
            this._head = null;
            this._tail = null;
        } else if (elem.equals(this._head)) {
            if (next == null) {
                throw new NullPointerException();
            }
            this._head = next;
            next.setPrev(null);
        } else if (elem.equals(this._tail)) {
            if (prev == null) {
                throw new NullPointerException();
            }
            this._tail = prev;
            prev.setNext(null);
        } else {
            if (next == null || prev == null) {
                throw new NullPointerException();
            }
            next.setPrev(prev);
            prev.setNext(next);
        }
        --this._size;
        ++this._modCount;
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeFirstOccurrence(obj);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null || this == c) {
            return true;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean addAll(Collection<? extends @NotNull E> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        if (c instanceof LinkedCollection) {
            @NotNull @NotNull LinkedCollection coll = (LinkedCollection)c;
            if (coll._tail == null || coll._head == null) {
                throw new NullPointerException();
            }
            @NotNull LinkedCollectionElement<@NotNull E> last = coll._tail;
            LinkedCollectionElement<@NotNull E> current = coll._head;
            this.add(current.getValue());
            while (current != last) {
                if ((current = current.getNext()) == null) {
                    throw new NullPointerException();
                }
                this.add(current.getValue());
            }
            return true;
        }
        boolean result = false;
        for (E elem : c) {
            if (!this.add(elem)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        if (this == c) {
            if (this.size() == 0) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean result = false;
        for (Object o : c) {
            while (this.remove(o)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this == c || this._head == null) {
            return false;
        }
        if (c == null) {
            this.clear();
            return true;
        }
        @NotNull Iterator<@NotNull E> iter = this.iterator();
        @NotNull LinkedCollection<@NotNull E> tmp = new LinkedCollection<E>();
        while (iter.hasNext()) {
            @NotNull E elem = iter.next();
            if (c.contains(elem)) continue;
            tmp.add(elem);
        }
        if (tmp.isEmpty()) {
            return false;
        }
        return this.removeAll(tmp);
    }

    @Override
    public void clear() {
        this._head = null;
        this._tail = null;
        this._size = 0;
        ++this._modCount;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collection)) {
            return false;
        }
        @NotNull Collection other = (Collection)obj;
        if (this._size != other.size()) {
            return false;
        }
        @NotNull Iterator<@NotNull E> iter = this.iterator();
        @NotNull Iterator<E> otherIter = other.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append("[");
        @NotNull Iterator<@NotNull E> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @NotNull
    private @NotNull LinkedCollectionElement<@NotNull E> merge(@NotNull @NotNull Comparator<@NotNull E> comparator, @NotNull @NotNull LinkedCollectionElement<@NotNull E> left, @NotNull @NotNull LinkedCollectionElement<@NotNull E> right) {
        LinkedCollectionElement<E> headTo;
        LinkedCollectionElement<E> headFrom;
        if (comparator.compare(left.getValue(), right.getValue()) > 0) {
            headFrom = left;
            headTo = right;
        } else {
            headFrom = right;
            headTo = left;
        }
        @NotNull LinkedCollectionElement<@NotNull E> target = headTo;
        while (headFrom != null) {
            @NotNull LinkedCollectionElement<@NotNull E> current = headFrom;
            headFrom = headFrom.getPrev();
            LinkedCollectionElement<@NotNull E> targetPrev = target.getPrev();
            while (targetPrev != null && comparator.compare(targetPrev.getValue(), current.getValue()) < 0) {
                target = targetPrev;
                targetPrev = target.getPrev();
            }
            if (targetPrev == null) {
                target.setPrev(current);
                break;
            }
            current.setPrev(targetPrev);
            target.setPrev(current);
        }
        return headTo;
    }

    public boolean sort(Comparator<@NotNull E> comparator) {
        LinkedCollectionElement current;
        if (comparator == null) {
            return false;
        }
        if (this._size <= 1 || this._head == null || this._tail == null) {
            return true;
        }
        ++this._modCount;
        for (current = this._head; current != null; current = current.getNext()) {
            current.setPrev(null);
        }
        while (this._head != null) {
            @NotNull LinkedCollectionElement<@NotNull E> left = this._head;
            LinkedCollectionElement<@NotNull E> right = left.getNext();
            if (right == null) {
                throw new NullPointerException();
            }
            this._head = right.getNext();
            left.setNext(null);
            right.setNext(null);
            @NotNull LinkedCollectionElement<@NotNull E> sorted = this.merge(comparator, left, right);
            this._tail.setNext(sorted);
            this._tail = sorted;
        }
        this._head = this._tail;
        this._tail.setNext(this._tail.getPrev());
        while (this._tail.getPrev() != null) {
            this._tail = this._tail.getPrev();
            if (this._tail == null) {
                throw new NullPointerException();
            }
            this._tail.setNext(this._tail.getPrev());
        }
        this._head.setPrev(null);
        current = this._head;
        LinkedCollectionElement<@NotNull E> next = current.getNext();
        while (next != null) {
            next.setPrev(current);
            current = next;
            next = current.getNext();
        }
        ++this._modCount;
        return true;
    }

    @NotNull
    private @NotNull LinkedCollectionElement<@NotNull E> find(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        for (LinkedCollectionElement<E> current = this._head; current != null; current = current.getNext()) {
            if (i == index) {
                return current;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    private LinkedCollectionElement<@NotNull E> findFirst(Object obj) {
        if (obj == null) {
            return null;
        }
        for (LinkedCollectionElement<E> current = this._head; current != null; current = current.getNext()) {
            if (!current.getValue().equals(obj)) continue;
            return current;
        }
        return null;
    }

    private LinkedCollectionElement<@NotNull E> findLast(Object obj) {
        if (obj == null) {
            return null;
        }
        for (LinkedCollectionElement<E> current = this._tail; current != null; current = current.getPrev()) {
            if (!current.getValue().equals(obj)) continue;
            return current;
        }
        return null;
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    @NotNull
    public E remove() {
        return this.pop();
    }

    @Override
    public E poll() {
        if (this._head == null) {
            return null;
        }
        @NotNull E value = this._head.getValue();
        this._head = this._head.getNext();
        if (this._head == null) {
            this._tail = null;
        } else {
            this._head.setPrev(null);
        }
        --this._size;
        ++this._modCount;
        return value;
    }

    @Override
    @NotNull
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this._head == null ? null : (E)this._head.getValue();
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        @NotNull LinkedCollectionElement<@NotNull E> newElem = new LinkedCollectionElement<E>(e, null, null);
        if (this._head == null || this._tail == null) {
            this._head = newElem;
            this._tail = newElem;
        } else {
            newElem.setNext(this._head);
            this._head.setPrev(newElem);
            this._head = newElem;
        }
        ++this._size;
        ++this._modCount;
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    @NotNull
    public E removeFirst() {
        E value = this.pollFirst();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    @NotNull
    public E removeLast() {
        E value = this.pollLast();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public E pollFirst() {
        return this.poll();
    }

    @Override
    public E pollLast() {
        if (this._tail == null) {
            return null;
        }
        @NotNull E value = this._tail.getValue();
        this._tail = this._tail.getPrev();
        if (this._tail == null) {
            this._head = null;
        } else {
            this._tail.setNext(null);
        }
        --this._size;
        ++this._modCount;
        return value;
    }

    @Override
    @NotNull
    public E getFirst() {
        if (this._head == null) {
            throw new NoSuchElementException();
        }
        return this._head.getValue();
    }

    @Override
    @NotNull
    public E getLast() {
        if (this._tail == null) {
            throw new NoSuchElementException();
        }
        return this._tail.getValue();
    }

    @Override
    public E peekFirst() {
        return this._head == null ? null : (E)this._head.getValue();
    }

    @Override
    public E peekLast() {
        return this._tail == null ? null : (E)this._tail.getValue();
    }

    @Override
    public boolean removeFirstOccurrence(Object obj) {
        if (this.isEmpty()) {
            return false;
        }
        return this.removeElement(this.findFirst(obj));
    }

    @Override
    public boolean removeLastOccurrence(Object obj) {
        if (this.isEmpty()) {
            return false;
        }
        return this.removeElement(this.findLast(obj));
    }

    @Override
    public void push(@NotNull E e) {
        this.addFirst(e);
    }

    @Override
    @NotNull
    public E pop() {
        E value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull E> descendingIterator() {
        return new LinkedCollectionDescendingIterator(this);
    }

    @NotNull
    public E get(int index) throws IndexOutOfBoundsException {
        return this.find(index).getValue();
    }

    @NotNull
    public E set(int index, @NotNull E element) throws IndexOutOfBoundsException {
        return this.find(index).setValue(element);
    }
}

