/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.collection;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.adt.collection.LinkedCollectionElement;
import jakarta.validation.constraints.NotNull;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class LinkedCollectionIterator<@NotNull E>
implements Iterator<E> {
    @NotNull
    private final @NotNull LinkedCollection<@NotNull E> _collection;
    private LinkedCollectionElement<@NotNull E> _current;
    private final int _expModCount;

    LinkedCollectionIterator(@NotNull @NotNull LinkedCollection<@NotNull E> collection) {
        this._collection = collection;
        this._expModCount = collection._modCount;
        this._current = collection._head;
    }

    @Override
    public boolean hasNext() {
        if (this._collection._modCount != this._expModCount) {
            throw new ConcurrentModificationException();
        }
        return this._current != null;
    }

    @Override
    @NotNull
    public E next() {
        if (this._collection._modCount != this._expModCount) {
            throw new ConcurrentModificationException();
        }
        if (this._current == null) {
            throw new NoSuchElementException();
        }
        @NotNull E result = this._current.getValue();
        this._current = this._current.getNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

