/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.AVLMapIntervall;
import de.svws_nrw.core.adt.map.AVLMapNode;
import de.svws_nrw.core.adt.map.AVLMapSubMap;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public final class AVLMap<@NotNull K, @NotNull V>
implements NavigableMap<K, V> {
    @NotNull
    private final K _infinityMinus = AVLMapIntervall._INFINITY_MINUS;
    @NotNull
    private final K _infinityPlus = AVLMapIntervall._INFINITY_PLUS;
    @NotNull
    private final V _dummyValue = new Object();
    @NotNull
    private final @NotNull AVLMapSubMap<@NotNull K, @NotNull V> _sub = new AVLMapSubMap(this, new AVLMapIntervall<K>(this._infinityMinus, false, this._infinityPlus, false), true);
    @NotNull
    private final @NotNull Comparator<@NotNull K> _comparator;
    @NotNull
    private final @NotNull Comparator<@NotNull K> _comparatorNatural = (key1, key2) -> {
        if (key1 == null || key2 == null) {
            throw new NullPointerException();
        }
        if (!(key1 instanceof Comparable) || !(key2 instanceof Comparable)) {
            throw new ClassCastException();
        }
        @NotNull @NotNull Comparable k1 = (Comparable)key1;
        return k1.compareTo(key2);
    };
    private AVLMapNode<@NotNull K, @NotNull V> _root = null;
    private boolean _allowKeyAlone = false;

    public AVLMap() {
        this._comparator = this._comparatorNatural;
    }

    public AVLMap(@NotNull @NotNull Comparator<@NotNull K> comparator) {
        this._comparator = comparator;
    }

    public AVLMap(@NotNull @NotNull SortedMap<@NotNull K, ? extends @NotNull V> map) {
        this._comparator = map.comparator();
        this._sub.putAll(map);
    }

    @NotNull
    public String toString() {
        return this._sub.toString();
    }

    public void allowKeyAlone(boolean b) {
        this._allowKeyAlone = b;
    }

    @Override
    public boolean equals(@NotNull Object o) {
        return this._sub.equals(o);
    }

    @Override
    public int hashCode() {
        return this._sub.hashCode();
    }

    @Override
    @NotNull
    public @NotNull Comparator<@NotNull K> comparator() {
        return this._sub.comparator();
    }

    @Override
    @NotNull
    public K firstKey() {
        return this._sub.firstKey();
    }

    @Override
    @NotNull
    public K lastKey() {
        return this._sub.lastKey();
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull K> keySet() {
        return this._sub.keySet();
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull V> values() {
        return this._sub.values();
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Map.Entry<@NotNull K, @NotNull V>> entrySet() {
        return this._sub.entrySet();
    }

    @Override
    public int size() {
        return this._sub.size();
    }

    @Override
    public boolean isEmpty() {
        return this._sub.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        return this._sub.containsKey(key);
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        return this._sub.containsValue(value);
    }

    @Override
    public V get(@NotNull Object key) {
        return this._sub.get(key);
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        return this._sub.put(key, value);
    }

    @Override
    public V remove(@NotNull Object key) {
        return this._sub.remove(key);
    }

    @Override
    public void putAll(@NotNull @NotNull Map<? extends @NotNull K, ? extends @NotNull V> m) {
        this._sub.putAll(m);
    }

    @Override
    public void clear() {
        this._sub.clear();
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> lowerEntry(@NotNull K key) {
        return this._sub.lowerEntry(key);
    }

    @Override
    public K lowerKey(@NotNull K key) {
        return this._sub.lowerKey(key);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> floorEntry(@NotNull K key) {
        return this._sub.floorEntry(key);
    }

    @Override
    public K floorKey(@NotNull K key) {
        return this._sub.floorKey(key);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> ceilingEntry(@NotNull K key) {
        return this._sub.ceilingEntry(key);
    }

    @Override
    public K ceilingKey(@NotNull K key) {
        return this._sub.ceilingKey(key);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> higherEntry(@NotNull K key) {
        return this._sub.higherEntry(key);
    }

    @Override
    public K higherKey(@NotNull K key) {
        return this._sub.higherKey(key);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> firstEntry() {
        return this._sub.firstEntry();
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> lastEntry() {
        return this._sub.lastEntry();
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> pollFirstEntry() {
        return this._sub.pollFirstEntry();
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> pollLastEntry() {
        return this._sub.pollLastEntry();
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> descendingMap() {
        return this._sub.descendingMap();
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> navigableKeySet() {
        return this._sub.navigableKeySet();
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> descendingKeySet() {
        return this._sub.descendingKeySet();
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> subMap(@NotNull K fromKey, boolean fromInclusive, @NotNull K toKey, boolean toInclusive) {
        return this._sub.subMap(fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> headMap(@NotNull K toKey, boolean inclusive) {
        return this._sub.headMap(toKey, inclusive);
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> tailMap(@NotNull K fromKey, boolean inclusive) {
        return this._sub.tailMap(fromKey, inclusive);
    }

    @Override
    @NotNull
    public @NotNull SortedMap<@NotNull K, @NotNull V> subMap(@NotNull K fromKey, @NotNull K toKey) {
        return this._sub.subMap(fromKey, toKey);
    }

    @Override
    @NotNull
    public @NotNull SortedMap<@NotNull K, @NotNull V> headMap(@NotNull K toKey) {
        return this._sub.headMap(toKey);
    }

    @Override
    @NotNull
    public @NotNull SortedMap<@NotNull K, @NotNull V> tailMap(@NotNull K fromKey) {
        return this._sub.tailMap(fromKey);
    }

    boolean bcAddEntryReturnBool(@NotNull @NotNull Map.Entry<@NotNull K, @NotNull V> e, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        V old = this.bcAddEntryReturnOldValueOrNull(e.getKey(), e.getValue(), iv);
        return !this._valEquals(old, e.getValue());
    }

    V bcAddEntryReturnOldValueOrNull(@NotNull K key, @NotNull V value, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (key == null) {
            throw new NullPointerException("TreeMap erlaubt keine NULL keys.");
        }
        if (this._isOutOfRange(key, iv)) {
            throw new IllegalArgumentException("Der Schl\u00fcsselwert liegt nicht im g\u00fcltigen Bereich.");
        }
        if (this._root == null) {
            this._root = new AVLMapNode<K, V>(key, value);
            return null;
        }
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeGetOrNull(key, iv);
        V old = node == null ? null : (V)node._val;
        this._root = this._nodePutRecursive(this._root, key, value);
        return old;
    }

    boolean bcAddAllEntries(@NotNull @NotNull Collection<? extends @NotNull Map.Entry<@NotNull K, @NotNull V>> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : c) {
            changed |= this.bcAddEntryReturnBool(entry, iv);
        }
        return changed;
    }

    void bcAddAllEntriesOfMap(@NotNull @NotNull Map<? extends @NotNull K, ? extends @NotNull V> map, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.bcAddEntryReturnOldValueOrNull(entry.getKey(), entry.getValue(), iv);
        }
    }

    boolean bcAddKey(@NotNull K e, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (!this._allowKeyAlone) {
            throw new UnsupportedOperationException();
        }
        if (this.bcContainsKey(e, iv)) {
            return false;
        }
        this.bcAddEntryReturnOldValueOrNull(e, this._dummyValue, iv);
        return true;
    }

    boolean bcAddAllKeys(@NotNull @NotNull Collection<? extends @NotNull K> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        boolean changed = false;
        for (K key : c) {
            changed |= this.bcAddKey(key, iv);
        }
        return changed;
    }

    boolean bcContainsKey(@NotNull Object objKey, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeGetOrNull(objKey, iv) != null;
    }

    boolean bcContainsAllKeys(@NotNull @NotNull Collection<@NotNull ?> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        for (Object key : c) {
            if (this.bcContainsKey(key, iv)) continue;
            return false;
        }
        return true;
    }

    boolean bcContainsValue(@NotNull Object objValue, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        @NotNull Object value = objValue;
        AVLMapNode<@NotNull K, @NotNull V> n1 = this._nodeFirstOrNull(iv);
        if (n1 == null) {
            return false;
        }
        AVLMapNode<@NotNull K, @NotNull V> n2 = this._nodeLastOrNull(iv);
        if (n2 == null) {
            return false;
        }
        while (n1 != n2) {
            if (n1 == null) {
                throw new NullPointerException();
            }
            if (this._valEquals(n1._val, value)) {
                return true;
            }
            n1 = n1._next;
        }
        return this._valEquals(n2._val, value);
    }

    boolean bcContainsAllValues(@NotNull @NotNull Collection<@NotNull ?> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        for (Object val : c) {
            if (this.bcContainsValue(val, iv)) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    boolean bcContainsEntry(@NotNull Object o, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        @NotNull @NotNull @NotNull Map.Entry e = (Map.Entry)o;
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeGetOrNull(e.getKey(), iv);
        if (node == null) {
            return false;
        }
        return this._valEquals(node._val, e.getValue());
    }

    boolean bcContainsAllEntries(@NotNull @NotNull Collection<@NotNull ?> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        for (Object entry : c) {
            if (this.bcContainsEntry(entry, iv)) continue;
            return false;
        }
        return true;
    }

    V bcRemoveKeyReturnOldValueOrNull(@NotNull Object obj, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (obj == null) {
            throw new NullPointerException("TreeMap unterst\u00fctzt keine NULL-Schl\u00fcssel.");
        }
        @NotNull Object key = obj;
        AVLMapNode<@NotNull Object, @NotNull V> old = this._nodeGetOrNull(key, iv);
        if (old == null) {
            return null;
        }
        if (this._root == null) {
            throw new NullPointerException();
        }
        this._root = this._nodeRemoveKeyRecursive(this._root, key);
        return old._val;
    }

    boolean bcRemoveKeyReturnBool(@NotNull Object o, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (!this.bcContainsKey(o, iv)) {
            return false;
        }
        this.bcRemoveKeyReturnOldValueOrNull(o, iv);
        return true;
    }

    boolean bcRemoveAllKeys(@NotNull @NotNull Collection<@NotNull ?> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        boolean changed = false;
        for (Object obj : c) {
            changed |= this.bcRemoveKeyReturnBool(obj, iv);
        }
        return changed;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    boolean bcRemoveEntry(@NotNull Object o, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        if (!this.bcContainsEntry(o, iv)) {
            return false;
        }
        if (this._root == null) {
            throw new NullPointerException();
        }
        @NotNull @NotNull @NotNull Map.Entry e = (Map.Entry)o;
        this._root = this._nodeRemoveKeyRecursive(this._root, e.getKey());
        return true;
    }

    boolean bcRemoveAllEntries(@NotNull @NotNull Collection<@NotNull ?> c, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        boolean removedAny = false;
        for (Object entry : c) {
            removedAny |= this.bcRemoveEntry(entry, iv);
        }
        return removedAny;
    }

    Map.Entry<@NotNull K, @NotNull V> bcPollFirstEntryOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeFirstOrNull(iv);
        if (node == null) {
            return null;
        }
        if (this._root == null) {
            throw new NullPointerException();
        }
        this._root = this._nodeRemoveKeyRecursive(this._root, node._key);
        return node;
    }

    K bcPollFirstKeyOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeFirstOrNull(iv);
        if (node == null) {
            return null;
        }
        if (this._root == null) {
            throw new NullPointerException();
        }
        this._root = this._nodeRemoveKeyRecursive(this._root, node._key);
        return node._key;
    }

    Map.Entry<@NotNull K, @NotNull V> bcPollLastEntryOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeLastOrNull(iv);
        if (node == null) {
            return null;
        }
        if (this._root == null) {
            throw new NullPointerException();
        }
        this._root = this._nodeRemoveKeyRecursive(this._root, node._key);
        return node;
    }

    K bcPollLastKeyOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeLastOrNull(iv);
        if (node == null) {
            return null;
        }
        if (this._root == null) {
            throw new NullPointerException();
        }
        this._root = this._nodeRemoveKeyRecursive(this._root, node._key);
        return node._key;
    }

    int bcGetSize(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> n1 = this._nodeFirstOrNull(iv);
        if (n1 == null) {
            return 0;
        }
        AVLMapNode<@NotNull K, @NotNull V> n2 = this._nodeLastOrNull(iv);
        if (n2 == null) {
            return 0;
        }
        return this._nodeIndexOf(n2._key) - this._nodeIndexOf(n1._key) + 1;
    }

    boolean bcIsEmpty(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeFirstOrNull(iv) == null;
    }

    @NotNull
    @NotNull Comparator<@NotNull K> bcGetComparator(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._comparator;
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetFirstEntryOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeFirstOrNull(iv);
    }

    @NotNull
    K bcGetFirstKeyOrException(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._keyOrExeption(this._nodeFirstOrNull(iv));
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetLastEntryOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeLastOrNull(iv);
    }

    @NotNull
    K bcGetLastKeyOrException(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._keyOrExeption(this._nodeLastOrNull(iv));
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetNextEntryOrNull(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> current, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeNextOrNull(current, iv);
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetPrevEntryOrNull(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> current, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodePrevOrNull(current, iv);
    }

    V bcGetValueOfKeyOrNull(@NotNull Object objKey, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        @NotNull Object key = objKey;
        AVLMapNode<@NotNull Object, @NotNull V> node = this._nodeGetOrNull(key, iv);
        return node == null ? null : (V)node._val;
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetLowerEntryOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeLowerOrNull(key, iv);
    }

    K bcGetLowerKeyOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._keyOrNull(this._nodeLowerOrNull(key, iv));
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetFloorEntryOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeFloorOrNull(key, iv);
    }

    K bcGetFloorKeyOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._keyOrNull(this._nodeFloorOrNull(key, iv));
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetCeilingEntryOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeCeilingOrNull(key, iv);
    }

    K bcGetCeilingKeyOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._keyOrNull(this._nodeCeilingOrNull(key, iv));
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetHigherEntryOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._nodeHigherOrNull(key, iv);
    }

    K bcGetHigherKeyOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return this._keyOrNull(this._nodeHigherOrNull(key, iv));
    }

    boolean bcCheckOutOfIntervall(@NotNull K key, boolean inc, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        if (key == this._infinityMinus || key == this._infinityPlus) {
            return false;
        }
        int cmpF = this._compare(key, iv.from);
        if (cmpF < 0) {
            return true;
        }
        if (cmpF == 0 && !iv.fromInc && inc) {
            return true;
        }
        int cmpT = this._compare(key, iv.to);
        if (cmpT > 0) {
            return true;
        }
        return cmpT == 0 && !iv.toInc && inc;
    }

    private K _keyOrNull(AVLMapNode<@NotNull K, @NotNull V> node) {
        return node == null ? null : (K)node._key;
    }

    private boolean _valEquals(V v1, V v2) {
        return v1 == null ? v2 == null : v1.equals(v2);
    }

    @NotNull
    private K _keyOrExeption(AVLMapNode<@NotNull K, @NotNull V> node) {
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node._key;
    }

    private int _compare(@NotNull K key1, @NotNull K key2) {
        if (key1 == this._infinityMinus || key2 == this._infinityPlus) {
            return -1;
        }
        if (key1 == this._infinityPlus || key2 == this._infinityMinus) {
            return 1;
        }
        return this._comparator.compare(key1, key2);
    }

    private boolean _isOutOfRange(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        int cmpKeyFrom = this._compare(key, iv.from);
        if (cmpKeyFrom < 0 || cmpKeyFrom == 0 && !iv.fromInc) {
            return true;
        }
        int cmpKeyTo = this._compare(key, iv.to);
        return cmpKeyTo > 0 || cmpKeyTo == 0 && !iv.toInc;
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeFirstOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return iv.fromInc ? this._nodeCeilingOrNull(iv.from, iv) : this._nodeHigherOrNull(iv.from, iv);
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeLastOrNull(@NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        return iv.toInc ? this._nodeFloorOrNull(iv.to, iv) : this._nodeLowerOrNull(iv.to, iv);
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeCeilingOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeDeepestOrNull(key, iv);
        if (node == null) {
            return null;
        }
        int cmpNodeKey = this._compare(node._key, key);
        return cmpNodeKey >= 0 ? node : this._nodeNextOrNull(node, iv);
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeHigherOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeDeepestOrNull(key, iv);
        if (node == null) {
            return null;
        }
        int cmpNodeKey = this._compare(node._key, key);
        return cmpNodeKey > 0 ? node : this._nodeNextOrNull(node, iv);
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeFloorOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeDeepestOrNull(key, iv);
        if (node == null) {
            return null;
        }
        int cmpNodeKey = this._compare(node._key, key);
        return cmpNodeKey <= 0 ? node : this._nodePrevOrNull(node, iv);
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeLowerOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeDeepestOrNull(key, iv);
        if (node == null) {
            return null;
        }
        int cmpNodeKey = this._compare(node._key, key);
        return cmpNodeKey < 0 ? node : this._nodePrevOrNull(node, iv);
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeNextOrNull(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> node, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> next = node._next;
        if (next == null) {
            return null;
        }
        return this._isOutOfRange(next._key, iv) ? null : next;
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodePrevOrNull(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> node, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> prev = node._prev;
        if (prev == null) {
            return null;
        }
        return this._isOutOfRange(prev._key, iv) ? null : prev;
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeGetOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> node = this._nodeDeepestOrNull(key, iv);
        if (node == null) {
            return null;
        }
        return this._compare(key, node._key) == 0 ? node : null;
    }

    private int _nodeIndexOf(@NotNull K key) {
        int sizeL;
        AVLMapNode<@NotNull K, @NotNull V> current = this._root;
        int index = 0;
        while (true) {
            if (current == null) {
                throw new NullPointerException();
            }
            int cmp = this._compare(key, current._key);
            if (cmp < 0) {
                current = current._childL;
                continue;
            }
            AVLMapNode<@NotNull K, @NotNull V> left = current._childL;
            int n = sizeL = left == null ? 0 : left._size;
            if (cmp <= 0) break;
            index += sizeL + 1;
            current = current._childR;
        }
        return index + sizeL;
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeDeepestOrNull(@NotNull K key, @NotNull @NotNull AVLMapIntervall<@NotNull K> iv) {
        AVLMapNode<@NotNull K, @NotNull V> current = this._root;
        AVLMapNode<K, V> last = null;
        while (current != null) {
            int cmpToKey = this._compare(iv.to, current._key);
            if (cmpToKey < 0 || cmpToKey == 0 && !iv.toInc) {
                current = current._childL;
                continue;
            }
            int cmpFromKey = this._compare(iv.from, current._key);
            if (cmpFromKey > 0 || cmpFromKey == 0 && !iv.fromInc) {
                current = current._childR;
                continue;
            }
            last = current;
            int cmp = this._compare(key, current._key);
            if (cmp < 0) {
                current = current._childL;
                continue;
            }
            if (cmp > 0) {
                current = current._childR;
                continue;
            }
            return current;
        }
        return last;
    }

    @NotNull
    private @NotNull AVLMapNode<@NotNull K, @NotNull V> _nodePutRecursive(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> current, @NotNull K key, @NotNull V value) {
        int cmp = this._compare(key, current._key);
        if (cmp == 0) {
            current._val = value;
            return current;
        }
        if (cmp < 0) {
            current._childL = current._childL == null ? this._nodeCreateLeaf(current._prev, current, key, value) : this._nodePutRecursive(current._childL, key, value);
        } else {
            current._childR = current._childR == null ? this._nodeCreateLeaf(current, current._next, key, value) : this._nodePutRecursive(current._childR, key, value);
        }
        return this._nodeRevalidate(current);
    }

    @NotNull
    private @NotNull AVLMapNode<@NotNull K, @NotNull V> _nodeCreateLeaf(AVLMapNode<@NotNull K, @NotNull V> prev, AVLMapNode<@NotNull K, @NotNull V> next, @NotNull K key, @NotNull V value) {
        AVLMapNode<@NotNull K, @NotNull V> child = new AVLMapNode<K, V>(key, value);
        if (prev != null) {
            prev._next = child;
            child._prev = prev;
        }
        if (next != null) {
            next._prev = child;
            child._next = next;
        }
        return child;
    }

    private AVLMapNode<@NotNull K, @NotNull V> _nodeRemoveKeyRecursive(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> current, @NotNull K key) {
        int cmp = this._compare(key, current._key);
        if (cmp < 0) {
            if (current._childL == null) {
                throw new NullPointerException();
            }
            current._childL = this._nodeRemoveKeyRecursive(current._childL, key);
            return this._nodeRevalidate(current);
        }
        if (cmp > 0) {
            if (current._childR == null) {
                throw new NullPointerException();
            }
            current._childR = this._nodeRemoveKeyRecursive(current._childR, key);
            return this._nodeRevalidate(current);
        }
        if (current._childL == null) {
            this._nodeRemovePrevNext(current);
            return current._childR;
        }
        if (current._childR == null) {
            this._nodeRemovePrevNext(current);
            return current._childL;
        }
        AVLMapNode<@NotNull K, @NotNull V> next = current._next;
        if (next == null) {
            throw new NullPointerException();
        }
        current._childR = this._nodeRemoveKeyRecursive(current._childR, next._key);
        return this._nodeRevalidate(this._nodeReplaceReferencesFromAwithB(next, current));
    }

    @NotNull
    private @NotNull AVLMapNode<@NotNull K, @NotNull V> _nodeReplaceReferencesFromAwithB(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> a, @NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> b) {
        a._childL = b._childL;
        a._childR = b._childR;
        AVLMapNode<@NotNull K, @NotNull V> p = b._prev;
        AVLMapNode<@NotNull K, @NotNull V> n = b._next;
        a._prev = p;
        a._next = n;
        if (p != null) {
            p._next = a;
        }
        if (n != null) {
            n._prev = a;
        }
        return a;
    }

    private void _nodeRemovePrevNext(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> current) {
        AVLMapNode<@NotNull K, @NotNull V> nodeP = current._prev;
        AVLMapNode<@NotNull K, @NotNull V> nodeN = current._next;
        if (nodeP != null) {
            nodeP._next = nodeN;
        }
        if (nodeN != null) {
            nodeN._prev = nodeP;
        }
    }

    @NotNull
    private @NotNull AVLMapNode<@NotNull K, @NotNull V> _nodeRevalidate(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> node) {
        int heightBalance = this._nodeGetHeightBalance(node);
        if (heightBalance > 1) {
            if (node._childR == null) {
                throw new NullPointerException();
            }
            if (this._nodeGetHeightBalance(node._childR) < 0) {
                node._childR = this._nodeRotateRight(node._childR);
            }
            return this._nodeRotateLeft(node);
        }
        if (heightBalance < -1) {
            if (node._childL == null) {
                throw new NullPointerException();
            }
            if (this._nodeGetHeightBalance(node._childL) > 0) {
                node._childL = this._nodeRotateLeft(node._childL);
            }
            return this._nodeRotateRight(node);
        }
        this._nodeRevalidateHeightAndSize(node);
        return node;
    }

    @NotNull
    private @NotNull AVLMapNode<@NotNull K, @NotNull V> _nodeRotateLeft(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> nodeM) {
        if (nodeM._childR == null) {
            throw new NullPointerException();
        }
        @NotNull AVLMapNode<@NotNull K, @NotNull V> nodeR = nodeM._childR;
        nodeM._childR = nodeR._childL;
        nodeR._childL = nodeM;
        this._nodeRevalidateHeightAndSize(nodeM);
        this._nodeRevalidateHeightAndSize(nodeR);
        return nodeR;
    }

    @NotNull
    private @NotNull AVLMapNode<@NotNull K, @NotNull V> _nodeRotateRight(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> nodeM) {
        if (nodeM._childL == null) {
            throw new NullPointerException();
        }
        @NotNull AVLMapNode<@NotNull K, @NotNull V> nodeL = nodeM._childL;
        nodeM._childL = nodeL._childR;
        nodeL._childR = nodeM;
        this._nodeRevalidateHeightAndSize(nodeM);
        this._nodeRevalidateHeightAndSize(nodeL);
        return nodeL;
    }

    private void _nodeRevalidateHeightAndSize(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> node) {
        int sizeL = node._childL == null ? 0 : node._childL._size;
        int sizeR = node._childR == null ? 0 : node._childR._size;
        node._size = sizeL + sizeR + 1;
        int heightL = node._childL == null ? 0 : node._childL._height;
        int heightR = node._childR == null ? 0 : node._childR._height;
        node._height = Math.max(heightL, heightR) + 1;
    }

    private int _nodeGetHeightBalance(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> node) {
        int heightL = node._childL == null ? 0 : node._childL._height;
        int heightR = node._childR == null ? 0 : node._childR._height;
        return heightR - heightL;
    }
}

