/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.AVLMapSubMap;
import jakarta.validation.constraints.NotNull;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class AVLMapSubEntrySetIterator<@NotNull K, @NotNull V>
implements Iterator<Map.Entry<K, V>> {
    @NotNull
    private final @NotNull AVLMapSubMap<@NotNull K, @NotNull V> _sub;
    private Map.Entry<@NotNull K, @NotNull V> _current;
    private Map.Entry<@NotNull K, @NotNull V> _next;

    AVLMapSubEntrySetIterator(@NotNull @NotNull AVLMapSubMap<@NotNull K, @NotNull V> sub) {
        this._sub = sub;
        this._current = null;
        this._next = this._sub.firstEntry();
    }

    @Override
    @NotNull
    public  @NotNull Map.Entry<@NotNull K, @NotNull V> next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        this._current = this._next;
        this._next = this._sub.higherEntry(this._next.getKey());
        return this._current;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public void remove() {
        if (this._current == null) {
            throw new IllegalStateException();
        }
        this._sub.remove(this._current.getKey());
        this._current = null;
    }
}

