/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.AVLMapSubMap;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;

public final class AVLMapSubKeySet<@NotNull K, @NotNull V>
implements NavigableSet<K> {
    @NotNull
    private final @NotNull AVLMapSubMap<@NotNull K, @NotNull V> _sub;

    AVLMapSubKeySet(@NotNull @NotNull AVLMapSubMap<@NotNull K, @NotNull V> sub) {
        this._sub = sub;
    }

    @NotNull
    public String toString() {
        return this._sub.toString();
    }

    @Override
    @NotNull
    public @NotNull Comparator<? super @NotNull K> comparator() {
        return this._sub.comparator();
    }

    @Override
    @NotNull
    public K first() {
        return this._sub.firstKey();
    }

    @Override
    @NotNull
    public K last() {
        return this._sub.lastKey();
    }

    @Override
    public int size() {
        return this._sub.size();
    }

    @Override
    public boolean isEmpty() {
        return this._sub.isEmpty();
    }

    @Override
    public boolean contains(@NotNull Object o) {
        return this._sub.containsKey(o);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this._sub.bcGetArrayListOfKeys().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this._sub.bcGetArrayListOfKeys().toArray(a);
    }

    @Override
    public boolean add(@NotNull K e) {
        return this._sub.bcAddKey(e);
    }

    @Override
    public boolean remove(@NotNull Object o) {
        return this._sub.bcRemoveKeyReturnBool(o);
    }

    @Override
    public boolean containsAll(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._sub.bcContainsAllKeys(c);
    }

    @Override
    public boolean addAll(@NotNull @NotNull Collection<? extends @NotNull K> c) {
        return this._sub.bcAddAllKeys(c);
    }

    @Override
    public boolean retainAll(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._sub.bcRetainAllKeys(c);
    }

    @Override
    public boolean removeAll(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._sub.bcRemoveAllKeys(c);
    }

    @Override
    public void clear() {
        this._sub.clear();
    }

    @Override
    public K lower(@NotNull K e) {
        return this._sub.bcGetLowerKeyOrNull(e);
    }

    @Override
    public K floor(@NotNull K e) {
        return this._sub.bcGetFloorKeyOrNull(e);
    }

    @Override
    public K ceiling(@NotNull K e) {
        return this._sub.bcGetCeilingKeyOrNull(e);
    }

    @Override
    public K higher(@NotNull K e) {
        return this._sub.bcGetHigherKeyOrNull(e);
    }

    @Override
    public K pollFirst() {
        return this._sub.bcPollFirstKeyOrNull();
    }

    @Override
    public K pollLast() {
        return this._sub.bcPollLastKeyOrNull();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull K> iterator() {
        return this._sub.bcGetSubKeySetIterator();
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> descendingSet() {
        return this._sub.bcGetSubKeySetDescending();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull K> descendingIterator() {
        return this._sub.bcGetSubKeySetDescendingIterator();
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> subSet(@NotNull K fromElement, boolean fromInclusive, @NotNull K toElement, boolean toInclusive) {
        return this._sub.bcGetSubKeySet(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> headSet(@NotNull K toElement, boolean inclusive) {
        return this._sub.bcGetSubKeyHeadSet(toElement, inclusive);
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> tailSet(@NotNull K fromElement, boolean inclusive) {
        return this._sub.bcGetSubKeyTailSet(fromElement, inclusive);
    }

    @Override
    @NotNull
    public @NotNull SortedSet<@NotNull K> subSet(@NotNull K fromElement, @NotNull K toElement) {
        return this._sub.bcGetSubKeySet(fromElement, toElement);
    }

    @Override
    @NotNull
    public @NotNull SortedSet<@NotNull K> headSet(@NotNull K toElement) {
        return this._sub.bcGetSubKeyHeadSet(toElement);
    }

    @Override
    @NotNull
    public @NotNull SortedSet<@NotNull K> tailSet(@NotNull K fromElement) {
        return this._sub.bcGetSubKeyTailSet(fromElement);
    }
}

