/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.AVLMapNode;
import de.svws_nrw.core.adt.map.AVLMapSubMap;
import jakarta.validation.constraints.NotNull;
import java.util.Iterator;
import java.util.NoSuchElementException;

class AVLMapSubKeySetIterator<@NotNull K, @NotNull V>
implements Iterator<K> {
    @NotNull
    private final @NotNull AVLMapSubMap<@NotNull K, @NotNull V> _sub;
    private AVLMapNode<@NotNull K, @NotNull V> _current;
    private AVLMapNode<@NotNull K, @NotNull V> _next;

    AVLMapSubKeySetIterator(@NotNull @NotNull AVLMapSubMap<@NotNull K, @NotNull V> sub) {
        this._sub = sub;
        this._current = null;
        this._next = this._sub.bcGetFirstEntryAsNode();
    }

    @Override
    @NotNull
    public K next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        this._current = this._next;
        this._next = this._sub.bcGetNextEntryOrNull(this._next);
        return this._current._key;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public void remove() {
        if (this._current == null) {
            throw new IllegalStateException();
        }
        this._sub.remove(this._current._key);
        this._current = null;
    }
}

