/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.AVLMap;
import de.svws_nrw.core.adt.map.AVLMapIntervall;
import de.svws_nrw.core.adt.map.AVLMapNode;
import de.svws_nrw.core.adt.map.AVLMapSubCollection;
import de.svws_nrw.core.adt.map.AVLMapSubCollectionIterator;
import de.svws_nrw.core.adt.map.AVLMapSubEntrySet;
import de.svws_nrw.core.adt.map.AVLMapSubEntrySetIterator;
import de.svws_nrw.core.adt.map.AVLMapSubKeySet;
import de.svws_nrw.core.adt.map.AVLMapSubKeySetIterator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class AVLMapSubMap<@NotNull K, @NotNull V>
implements NavigableMap<K, V> {
    @NotNull
    private final @NotNull AVLMap<@NotNull K, @NotNull V> _par;
    @NotNull
    private final @NotNull AVLMapIntervall<@NotNull K> _iv;
    private final boolean _asc;

    AVLMapSubMap(@NotNull @NotNull AVLMap<@NotNull K, @NotNull V> parent, @NotNull @NotNull AVLMapIntervall<@NotNull K> intervall, boolean asc) {
        this._par = parent;
        this._iv = intervall;
        this._asc = asc;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entries = [");
        boolean first = true;
        for (Map.Entry<K, V> e : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(e);
        }
        sb.append("], iv = ");
        sb.append(this._iv);
        sb.append(", asc = ");
        sb.append(this._asc);
        return sb.toString();
    }

    @Override
    public boolean equals(@NotNull Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mapO = (Map)o;
        if (mapO.size() != this.size()) {
            return false;
        }
        for (Map.Entry<K, V> e : this.entrySet()) {
            if (e.getValue().equals(mapO.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            h += entry.hashCode();
        }
        return h;
    }

    @Override
    @NotNull
    public @NotNull Comparator<@NotNull K> comparator() {
        return this._par.bcGetComparator(this._iv);
    }

    @Override
    @NotNull
    public K firstKey() {
        return this._asc ? this._par.bcGetFirstKeyOrException(this._iv) : this._par.bcGetLastKeyOrException(this._iv);
    }

    @Override
    @NotNull
    public K lastKey() {
        return this._asc ? this._par.bcGetLastKeyOrException(this._iv) : this._par.bcGetFirstKeyOrException(this._iv);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull K> keySet() {
        return new AVLMapSubKeySet(this);
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull V> values() {
        return new AVLMapSubCollection(this);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Map.Entry<@NotNull K, @NotNull V>> entrySet() {
        return new AVLMapSubEntrySet(this);
    }

    @Override
    public int size() {
        return this._par.bcGetSize(this._iv);
    }

    @Override
    public boolean isEmpty() {
        return this._par.bcIsEmpty(this._iv);
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        return this._par.bcContainsKey(key, this._iv);
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        return this._par.bcContainsValue(value, this._iv);
    }

    @Override
    public V get(@NotNull Object key) {
        return this._par.bcGetValueOfKeyOrNull(key, this._iv);
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        return this._par.bcAddEntryReturnOldValueOrNull(key, value, this._iv);
    }

    @Override
    public V remove(@NotNull Object key) {
        return this._par.bcRemoveKeyReturnOldValueOrNull(key, this._iv);
    }

    @Override
    public void putAll(@NotNull @NotNull Map<? extends @NotNull K, ? extends @NotNull V> map) {
        this._par.bcAddAllEntriesOfMap(map, this._iv);
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, V>> iter = this.bcGetSubEntrySetIterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> lowerEntry(@NotNull K key) {
        return this._asc ? this._par.bcGetLowerEntryOrNull(key, this._iv) : this._par.bcGetHigherEntryOrNull(key, this._iv);
    }

    @Override
    public K lowerKey(@NotNull K key) {
        return this._asc ? this._par.bcGetLowerKeyOrNull(key, this._iv) : this._par.bcGetHigherKeyOrNull(key, this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> floorEntry(@NotNull K key) {
        return this._asc ? this._par.bcGetFloorEntryOrNull(key, this._iv) : this._par.bcGetCeilingEntryOrNull(key, this._iv);
    }

    @Override
    public K floorKey(@NotNull K key) {
        return this._asc ? this._par.bcGetFloorKeyOrNull(key, this._iv) : this._par.bcGetCeilingKeyOrNull(key, this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> ceilingEntry(@NotNull K key) {
        return this._asc ? this._par.bcGetCeilingEntryOrNull(key, this._iv) : this._par.bcGetFloorEntryOrNull(key, this._iv);
    }

    @Override
    public K ceilingKey(@NotNull K key) {
        return this._asc ? this._par.bcGetCeilingKeyOrNull(key, this._iv) : this._par.bcGetFloorKeyOrNull(key, this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> higherEntry(@NotNull K key) {
        return this._asc ? this._par.bcGetHigherEntryOrNull(key, this._iv) : this._par.bcGetLowerEntryOrNull(key, this._iv);
    }

    @Override
    public K higherKey(@NotNull K key) {
        return this._asc ? this._par.bcGetHigherKeyOrNull(key, this._iv) : this._par.bcGetLowerKeyOrNull(key, this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> firstEntry() {
        return this._asc ? this._par.bcGetFirstEntryOrNull(this._iv) : this._par.bcGetLastEntryOrNull(this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> lastEntry() {
        return this._asc ? this._par.bcGetLastEntryOrNull(this._iv) : this._par.bcGetFirstEntryOrNull(this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> pollFirstEntry() {
        return this._asc ? this._par.bcPollFirstEntryOrNull(this._iv) : this._par.bcPollLastEntryOrNull(this._iv);
    }

    @Override
    public Map.Entry<@NotNull K, @NotNull V> pollLastEntry() {
        return this._asc ? this._par.bcPollLastEntryOrNull(this._iv) : this._par.bcPollFirstEntryOrNull(this._iv);
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> descendingMap() {
        return new AVLMapSubMap<K, V>(this._par, this._iv, !this._asc);
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> navigableKeySet() {
        return new AVLMapSubKeySet(this);
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull K> descendingKeySet() {
        return new AVLMapSubKeySet<K, V>(new AVLMapSubMap<K, V>(this._par, this._iv, !this._asc));
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> subMap(@NotNull K fromKey, boolean fromInclusive, @NotNull K toKey, boolean toInclusive) {
        return this._createMap(fromKey, fromInclusive, toKey, toInclusive, this._asc);
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> headMap(@NotNull K toKey, boolean inclusive) {
        return this._createMap(this._iv.from, this._iv.fromInc, toKey, inclusive, this._asc);
    }

    @Override
    @NotNull
    public @NotNull NavigableMap<@NotNull K, @NotNull V> tailMap(@NotNull K fromKey, boolean inclusive) {
        return this._createMap(fromKey, inclusive, this._iv.to, this._iv.toInc, this._asc);
    }

    @Override
    @NotNull
    public @NotNull SortedMap<@NotNull K, @NotNull V> subMap(@NotNull K fromKey, @NotNull K toKey) {
        return this._createMap(fromKey, true, toKey, false, this._asc);
    }

    @Override
    @NotNull
    public @NotNull SortedMap<@NotNull K, @NotNull V> headMap(@NotNull K toKey) {
        return this._createMap(this._iv.from, this._iv.fromInc, toKey, false, this._asc);
    }

    @Override
    @NotNull
    public @NotNull SortedMap<@NotNull K, @NotNull V> tailMap(@NotNull K fromKey) {
        return this._createMap(fromKey, true, this._iv.to, this._iv.toInc, this._asc);
    }

    boolean bcAddKey(@NotNull K e) {
        return this._par.bcAddKey(e, this._iv);
    }

    boolean bcAddAllKeys(@NotNull @NotNull Collection<? extends @NotNull K> c) {
        return this._par.bcAddAllKeys(c, this._iv);
    }

    boolean bcAddEntryReturnBool(@NotNull @NotNull Map.Entry<@NotNull K, @NotNull V> e) {
        return this._par.bcAddEntryReturnBool(e, this._iv);
    }

    boolean bcAddAllEntries(@NotNull @NotNull Collection<? extends @NotNull Map.Entry<@NotNull K, @NotNull V>> c) {
        return this._par.bcAddAllEntries(c, this._iv);
    }

    boolean bcContainsAllKeys(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._par.bcContainsAllKeys(c, this._iv);
    }

    boolean bcContainsEntry(@NotNull Object o) {
        return this._par.bcContainsEntry(o, this._iv);
    }

    boolean bcContainsAllEntries(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._par.bcContainsAllEntries(c, this._iv);
    }

    boolean bcContainsAllValues(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._par.bcContainsAllValues(c, this._iv);
    }

    boolean bcRemoveKeyReturnBool(@NotNull Object o) {
        return this._par.bcRemoveKeyReturnBool(o, this._iv);
    }

    boolean bcRemoveAllKeys(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._par.bcRemoveAllKeys(c, this._iv);
    }

    boolean bcRemoveEntry(@NotNull Object o) {
        return this._par.bcRemoveEntry(o, this._iv);
    }

    boolean bcRemoveAllEntries(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._par.bcRemoveAllEntries(c, this._iv);
    }

    K bcPollFirstKeyOrNull() {
        return this._asc ? this._par.bcPollFirstKeyOrNull(this._iv) : this._par.bcPollLastKeyOrNull(this._iv);
    }

    K bcPollLastKeyOrNull() {
        return this._asc ? this._par.bcPollLastKeyOrNull(this._iv) : this._par.bcPollFirstKeyOrNull(this._iv);
    }

    boolean bcRetainAllKeys(@NotNull @NotNull Collection<@NotNull ?> c) {
        Object key;
        @NotNull AVLMap<@NotNull ?, @NotNull ?> mapRetain = new AVLMap();
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            Object obj;
            key = obj = iterator.next();
            mapRetain.put(key, key);
        }
        boolean changed = false;
        Iterator<K> iterOfKeys = this.bcGetSubKeySetIterator();
        while (iterOfKeys.hasNext()) {
            key = iterOfKeys.next();
            if (mapRetain.containsKey(key)) continue;
            iterOfKeys.remove();
            changed = true;
        }
        return changed;
    }

    boolean bcRetainAllEntries(@NotNull @NotNull Collection<@NotNull ?> c) {
        @NotNull AVLMap<@NotNull K, @NotNull V> mapSave = new AVLMap();
        @NotNull Set<@NotNull Map.Entry<@NotNull K, @NotNull V>> setSave = mapSave.entrySet();
        for (Object o : c) {
            if (!this._par.bcContainsEntry(o, this._iv)) continue;
            setSave.add((Map.Entry)o);
        }
        boolean changed = false;
        Iterator<Map.Entry<K, V>> iterOfEntries = this.bcGetSubEntrySetIterator();
        while (iterOfEntries.hasNext()) {
            if (setSave.contains(iterOfEntries.next())) continue;
            iterOfEntries.remove();
            changed = true;
        }
        return changed;
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetFirstEntryAsNode() {
        return this._asc ? this._par.bcGetFirstEntryOrNull(this._iv) : this._par.bcGetLastEntryOrNull(this._iv);
    }

    AVLMapNode<@NotNull K, @NotNull V> bcGetNextEntryOrNull(@NotNull @NotNull AVLMapNode<@NotNull K, @NotNull V> node) {
        return this._asc ? this._par.bcGetNextEntryOrNull(node, this._iv) : this._par.bcGetPrevEntryOrNull(node, this._iv);
    }

    K bcGetFloorKeyOrNull(@NotNull K e) {
        return this._asc ? this._par.bcGetFloorKeyOrNull(e, this._iv) : this._par.bcGetCeilingKeyOrNull(e, this._iv);
    }

    K bcGetCeilingKeyOrNull(@NotNull K e) {
        return this._asc ? this._par.bcGetCeilingKeyOrNull(e, this._iv) : this._par.bcGetFloorKeyOrNull(e, this._iv);
    }

    K bcGetLowerKeyOrNull(@NotNull K e) {
        return this._asc ? this._par.bcGetLowerKeyOrNull(e, this._iv) : this._par.bcGetHigherKeyOrNull(e, this._iv);
    }

    K bcGetHigherKeyOrNull(@NotNull K e) {
        return this._asc ? this._par.bcGetHigherKeyOrNull(e, this._iv) : this._par.bcGetLowerKeyOrNull(e, this._iv);
    }

    @NotNull
    ArrayList<K> bcGetArrayListOfKeys() {
        ArrayList<K> v = new ArrayList<K>();
        Iterator<K> iter = this.navigableKeySet().iterator();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        return v;
    }

    @NotNull
    ArrayList<V> bcGetArrayListOfValues() {
        ArrayList<V> v = new ArrayList<V>();
        Iterator<V> iter = this.values().iterator();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        return v;
    }

    @NotNull
    ArrayList<Map.Entry<K, V>> bcGetArrayListOfEntries() {
        ArrayList<Map.Entry<K, V>> v = new ArrayList<Map.Entry<K, V>>();
        Iterator<Map.Entry<K, V>> iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        return v;
    }

    @NotNull
    @NotNull Iterator<@NotNull K> bcGetSubKeySetIterator() {
        return new AVLMapSubKeySetIterator(this);
    }

    @NotNull
    @NotNull Iterator<@NotNull V> bcGetSubCollectionIterator() {
        return new AVLMapSubCollectionIterator(this);
    }

    @NotNull
    @NotNull Iterator<@NotNull Map.Entry<@NotNull K, @NotNull V>> bcGetSubEntrySetIterator() {
        return new AVLMapSubEntrySetIterator(this);
    }

    @NotNull
    @NotNull NavigableSet<@NotNull K> bcGetSubKeySetDescending() {
        return new AVLMapSubKeySet<K, V>(new AVLMapSubMap<K, V>(this._par, this._iv, !this._asc));
    }

    @NotNull
    @NotNull Iterator<@NotNull K> bcGetSubKeySetDescendingIterator() {
        return new AVLMapSubKeySetIterator<K, V>(new AVLMapSubMap<K, V>(this._par, this._iv, !this._asc));
    }

    @NotNull
    @NotNull NavigableSet<@NotNull K> bcGetSubKeySet(@NotNull K fromElement, boolean fromInclusive, @NotNull K toElement, boolean toInclusive) {
        return this._createSet(fromElement, fromInclusive, toElement, toInclusive, this._asc);
    }

    @NotNull
    @NotNull NavigableSet<@NotNull K> bcGetSubKeyHeadSet(@NotNull K toElement, boolean inclusive) {
        return this._createSet(this._iv.from, this._iv.fromInc, toElement, inclusive, this._asc);
    }

    @NotNull
    @NotNull NavigableSet<@NotNull K> bcGetSubKeyTailSet(@NotNull K fromElement, boolean inclusive) {
        return this._createSet(fromElement, inclusive, this._iv.to, this._iv.toInc, this._asc);
    }

    @NotNull
    @NotNull SortedSet<@NotNull K> bcGetSubKeySet(@NotNull K fromElement, @NotNull K toElement) {
        return this._createSet(fromElement, true, toElement, false, this._asc);
    }

    @NotNull
    @NotNull SortedSet<@NotNull K> bcGetSubKeyHeadSet(@NotNull K toElement) {
        return this._createSet(this._iv.from, this._iv.fromInc, toElement, false, this._asc);
    }

    @NotNull
    @NotNull SortedSet<@NotNull K> bcGetSubKeyTailSet(@NotNull K fromElement) {
        return this._createSet(fromElement, true, this._iv.to, this._iv.toInc, this._asc);
    }

    @NotNull
    private @NotNull AVLMapSubMap<@NotNull K, @NotNull V> _createMap(@NotNull K from, boolean fromInc, @NotNull K to, boolean toInc, boolean asc) {
        if (this._par.bcCheckOutOfIntervall(from, fromInc, this._iv)) {
            throw new IllegalArgumentException("FROM-KEY " + String.valueOf(from) + "/" + fromInc + " nicht in " + String.valueOf(this._iv));
        }
        if (this._par.bcCheckOutOfIntervall(to, toInc, this._iv)) {
            throw new IllegalArgumentException("TO-KEY " + String.valueOf(to) + "/" + toInc + " nicht in " + String.valueOf(this._iv));
        }
        return new AVLMapSubMap<K, V>(this._par, new AVLMapIntervall<K>(from, fromInc, to, toInc), asc);
    }

    @NotNull
    private @NotNull AVLMapSubKeySet<@NotNull K, @NotNull V> _createSet(@NotNull K from, boolean fromInc, @NotNull K to, boolean toInc, boolean asc) {
        return new AVLMapSubKeySet<K, V>(this._createMap(from, fromInc, to, toInc, asc));
    }
}

