/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.ArrayMapCollection;
import de.svws_nrw.core.adt.map.ArrayMapEntry;
import de.svws_nrw.core.adt.map.ArrayMapEntrySet;
import de.svws_nrw.core.adt.map.ArrayMapKeySet;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class ArrayMap<@NotNull K, @NotNull V>
implements Map<K, V> {
    @NotNull
    private final @NotNull K @NotNull [] keyArray;
    @NotNull
    private final @NotNull Function<@NotNull K, @NotNull Integer> keyIndexFunction;
    @NotNull
    private final @NotNull ArrayMapEntry<@NotNull K, @NotNull V>[] entries;
    @NotNull
    private final @NotNull Set<@NotNull K> _keySet;
    @NotNull
    private final @NotNull Collection<@NotNull V> _collection;
    @NotNull
    private final @NotNull Set<@NotNull Map.Entry<@NotNull K, @NotNull V>> _entrySet;
    @NotNull
    private int numEntries = 0;
    @NotNull
    private final @NotNull Function<@NotNull K, @NotNull Integer> keyIndexFunctionEnum = key -> {
        boolean isEnum = key instanceof Enum;
        if (!isEnum) {
            throw new IllegalArgumentException("Der Schl\u00fcsselwerte ist keine Enum-Konstanten und somit nicht zul\u00e4ssig.");
        }
        return ((Enum)key).ordinal();
    };

    public ArrayMap(@NotNull @NotNull K @NotNull [] keyArray) {
        if (keyArray.length <= 0) {
            throw new IllegalArgumentException("Das Array mit den g\u00fcltigen Schl\u00fcsselwerten darf nicht leer sein.");
        }
        @NotNull K firstKey = keyArray[0];
        if (!(firstKey instanceof Enum)) {
            throw new IllegalArgumentException("Enth\u00e4lt das Array der Schl\u00fcsselwerte keine Enum-Konstanten, so muss ein Funktion f\u00fcr die Zuordnung von Schl\u00fcsselwerten angegeben werden.");
        }
        this.keyArray = keyArray;
        this.keyIndexFunction = this.keyIndexFunctionEnum;
        this.entries = (ArrayMapEntry[])Array.newInstance(ArrayMapEntry.class, keyArray.length);
        this._keySet = new ArrayMapKeySet(this);
        this._collection = new ArrayMapCollection(this);
        this._entrySet = new ArrayMapEntrySet(this);
    }

    public ArrayMap(@NotNull @NotNull K @NotNull [] keyArray, @NotNull @NotNull Function<@NotNull K, @NotNull Integer> keyIndexFunction) {
        if (keyArray.length <= 0) {
            throw new IllegalArgumentException("Das Array mit den g\u00fcltigen Schl\u00fcsselwerten darf nicht leer sein.");
        }
        this.keyArray = keyArray;
        this.keyIndexFunction = keyIndexFunction;
        this.entries = (ArrayMapEntry[])Array.newInstance(ArrayMapEntry.class, keyArray.length);
        this._keySet = new ArrayMapKeySet(this);
        this._collection = new ArrayMapCollection(this);
        this._entrySet = new ArrayMapEntrySet(this);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull K> keySet() {
        return this._keySet;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull V> values() {
        return this._collection;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Map.Entry<@NotNull K, @NotNull V>> entrySet() {
        return this._entrySet;
    }

    public int getNumberOfKeys() {
        return this.keyArray.length;
    }

    @Override
    public int size() {
        return this.numEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    private boolean isValidIndex(int index) {
        return index >= 0 && index < this.keyArray.length;
    }

    public K getKeyAt(int index) {
        return this.isValidIndex(index) ? (K)this.keyArray[index] : null;
    }

    ArrayMapEntry<@NotNull K, @NotNull V> getEntryByIndex(int index) {
        return this.isValidIndex(index) ? this.entries[index] : null;
    }

    ArrayMapEntry<@NotNull K, @NotNull V> getEntry(Object key) {
        Object k = key;
        if (k == null) {
            return null;
        }
        int index = this.keyIndexFunction.apply(k);
        return this.getEntryByIndex(index);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (ArrayMapEntry<K, V> entry : this.entries) {
            if (entry == null || !value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        ArrayMapEntry<@NotNull K, @NotNull V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    public V getValueAt(int index) {
        if (!this.isValidIndex(index)) {
            throw new ArrayIndexOutOfBoundsException("Fehlerhafter Index f\u00fcr die Schl\u00fcsselwerte");
        }
        ArrayMapEntry<@NotNull K, @NotNull V> entry = this.getEntryByIndex(index);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        int index = this.keyIndexFunction.apply(key);
        if (!this.isValidIndex(index)) {
            throw new IllegalArgumentException("Der Schl\u00fcsselwert ist ung\u00fcltig und kann keinem Index zugeordnet werden.");
        }
        ArrayMapEntry<@NotNull K, @NotNull V> entry = this.getEntryByIndex(index);
        if (entry == null) {
            ++this.numEntries;
        }
        this.entries[index] = new ArrayMapEntry<K, V>(key, value);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Der Schl\u00fcsselwert darf nicht null sein.");
        }
        int index = this.keyIndexFunction.apply(key);
        if (!this.isValidIndex(index)) {
            return null;
        }
        ArrayMapEntry<@NotNull K, @NotNull V> entry = this.getEntryByIndex(index);
        if (entry != null) {
            this.entries[index] = null;
            --this.numEntries;
        }
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public void putAll(Map<? extends @NotNull K, ? extends @NotNull V> map) {
        if (map == null) {
            throw new NullPointerException("Der Parameter map darf nicht null sein.");
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.entries, null);
        this.numEntries = 0;
    }
}

