/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.adt.map.ArrayMapCollectionIterator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

final class ArrayMapCollection<@NotNull K, @NotNull V>
implements Collection<V> {
    @NotNull
    private final @NotNull ArrayMap<@NotNull K, @NotNull V> _map;

    ArrayMapCollection(@NotNull @NotNull ArrayMap<@NotNull K, @NotNull V> map) {
        this._map = map;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this._map.containsValue(obj);
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull V> iterator() {
        return new ArrayMapCollectionIterator<K, V>(this._map);
    }

    @NotNull
    private @NotNull List<@NotNull V> getValueList() {
        @NotNull ArrayList<@NotNull V> list = new ArrayList<V>(this._map.size());
        for (int i = 0; i < this._map.getNumberOfKeys(); ++i) {
            V value = this._map.getValueAt(i);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.getValueList().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.getValueList().toArray(a);
    }

    @Override
    public boolean add(@NotNull V e) {
        throw new UnsupportedOperationException("add: Werte k\u00f6nnen nicht ohne Schl\u00fcsselwerte hinzugef\u00fcgt werden.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove: Werte k\u00f6nnen nicht ohne einen Schl\u00fcsselwert entfernt werden.");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == null || this == collection) {
            return true;
        }
        for (Object obj : collection) {
            if (this._map.containsValue(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends @NotNull V> c) {
        throw new UnsupportedOperationException("addAll: Werte k\u00f6nnen nicht ohne Schl\u00fcsselwerte hinzugef\u00fcgt werden.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll: Werte k\u00f6nnen nicht ohne einen Schl\u00fcsselwert entfernt werden.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll: Werte k\u00f6nnen nicht ohne einen Schl\u00fcsselwert entfernt werden.");
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

