/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.adt.map.ArrayMapEntry;
import de.svws_nrw.core.adt.map.ArrayMapEntrySetIterator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ArrayMapEntrySet<@NotNull K, @NotNull V>
implements Set<Map.Entry<K, V>> {
    @NotNull
    private final @NotNull ArrayMap<@NotNull K, @NotNull V> _map;

    ArrayMapEntrySet(@NotNull @NotNull ArrayMap<@NotNull K, @NotNull V> map) {
        this._map = map;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Map.Entry<@NotNull K, @NotNull V> toEntry(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map.Entry)) {
            return null;
        }
         @NotNull @NotNull @NotNull Map.Entry entry = (Map.Entry)obj;
        return entry;
    }

    private boolean containsEntry(Map.Entry<@NotNull K, @NotNull V> entry) {
        if (entry == null) {
            return false;
        }
        if (!this._map.containsKey(entry.getKey())) {
            return false;
        }
        V value = this._map.get(entry.getKey());
        if (value == null) {
            return false;
        }
        return value.equals(entry.getValue());
    }

    @Override
    public boolean contains(Object obj) {
        Map.Entry<@NotNull K, @NotNull V> entry = this.toEntry(obj);
        if (entry == null) {
            return false;
        }
        return this.containsEntry(entry);
    }

    @Override
    @NotNull
    public @NotNull Iterator< @NotNull Map.Entry<@NotNull K, @NotNull V>> iterator() {
        return new ArrayMapEntrySetIterator<K, V>(this._map);
    }

    @NotNull
    private @NotNull List<@NotNull ArrayMapEntry<@NotNull K, @NotNull V>> getEntryList() {
        @NotNull ArrayList<@NotNull ArrayMapEntry<@NotNull K, @NotNull V>> list = new ArrayList<ArrayMapEntry<K, V>>(this._map.size());
        for (int i = 0; i < this._map.getNumberOfKeys(); ++i) {
            ArrayMapEntry<@NotNull K, @NotNull V> value = this._map.getEntryByIndex(i);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.getEntryList().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.getEntryList().toArray(a);
    }

    @Override
    public boolean add(@NotNull  @NotNull Map.Entry<@NotNull K, @NotNull V> e) {
        if (e == null) {
            return false;
        }
        this._map.put(e.getKey(), e.getValue());
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        Map.Entry<@NotNull K, @NotNull V> entry = this.toEntry(obj);
        if (entry == null) {
            return false;
        }
        if (!this.containsEntry(entry)) {
            return false;
        }
        this._map.remove(entry.getKey());
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == null || this == collection) {
            return true;
        }
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends  @NotNull Map.Entry<@NotNull K, @NotNull V>> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (this == collection) {
            return true;
        }
        for (Map.Entry<K, V> entry : collection) {
            if (this.add(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean changed = false;
        for (int i = 0; i < this._map.getNumberOfKeys(); ++i) {
            ArrayMapEntry<@NotNull K, @NotNull V> entry = this._map.getEntryByIndex(i);
            if (entry == null || collection.contains(entry)) continue;
            this._map.remove(entry.getKey());
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean changed = false;
        for (Object obj : collection) {
            if (!this.contains(obj)) continue;
            this.remove(obj);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

