/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.adt.map.ArrayMapEntry;
import jakarta.validation.constraints.NotNull;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

class ArrayMapEntrySetIterator<@NotNull K, @NotNull V>
implements Iterator<Map.Entry<K, V>> {
    @NotNull
    private final @NotNull ArrayMap<@NotNull K, @NotNull V> _map;
    private Integer _current;
    private Integer _next;

    ArrayMapEntrySetIterator(@NotNull @NotNull ArrayMap<@NotNull K, @NotNull V> map) {
        this._map = map;
        this._current = null;
        this._next = this.getNextIndex(this._current);
    }

    private Integer getNextIndex(Integer from) {
        int start;
        for (int i = start = from == null ? 0 : from + 1; i < this._map.getNumberOfKeys(); ++i) {
            if (this._map.getEntryByIndex(i) == null) continue;
            return i;
        }
        return null;
    }

    @Override
    @NotNull
    public  @NotNull Map.Entry<@NotNull K, @NotNull V> next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        this._current = this._next;
        this._next = this.getNextIndex(this._current);
        ArrayMapEntry<@NotNull K, @NotNull V> result = this._map.getEntryByIndex(this._current);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public void remove() {
        if (this._current == null) {
            throw new IllegalStateException();
        }
        this._map.remove(this._map.getKeyAt(this._current));
        this._current = null;
    }
}

