/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.adt.map.ArrayMapEntry;
import de.svws_nrw.core.adt.map.ArrayMapKeySetIterator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class ArrayMapKeySet<@NotNull K, @NotNull V>
implements Set<K> {
    @NotNull
    private final @NotNull ArrayMap<@NotNull K, @NotNull V> _map;

    ArrayMapKeySet(@NotNull @NotNull ArrayMap<@NotNull K, @NotNull V> map) {
        this._map = map;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this._map.containsKey(obj);
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull K> iterator() {
        return new ArrayMapKeySetIterator<K, V>(this._map);
    }

    @NotNull
    private @NotNull List<@NotNull K> getKeyList() {
        @NotNull ArrayList<@NotNull K> list = new ArrayList<K>(this._map.size());
        for (int i = 0; i < this._map.getNumberOfKeys(); ++i) {
            ArrayMapEntry<@NotNull K, @NotNull V> value = this._map.getEntryByIndex(i);
            if (value == null) continue;
            list.add(value.getKey());
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.getKeyList().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.getKeyList().toArray(a);
    }

    @Override
    public boolean add(@NotNull K e) {
        throw new UnsupportedOperationException("add: Es kann kein Schl\u00fcsselwert ohne zugeordnetem Wert hinzugef\u00fcgt werden (null ist nicht erlaubt).");
    }

    @Override
    public boolean remove(Object obj) {
        return this._map.remove(obj) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == null || this == collection) {
            return true;
        }
        for (Object obj : collection) {
            if (this._map.containsKey(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends @NotNull K> c) {
        throw new UnsupportedOperationException("addAll: Es kann kein Schl\u00fcsselwert ohne zugeordnetem Wert hinzugef\u00fcgt werden (null ist nicht erlaubt).");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean changed = false;
        for (int i = 0; i < this._map.getNumberOfKeys(); ++i) {
            ArrayMapEntry<@NotNull K, @NotNull V> entry = this._map.getEntryByIndex(i);
            if (entry == null || collection.contains(entry.getKey())) continue;
            this._map.remove(entry.getKey());
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        for (Object obj : collection) {
            if (!this._map.containsKey(obj)) continue;
            this._map.remove(obj);
            removed = true;
        }
        return removed;
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

