/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.map;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashMap2D<@NotNull K1, @NotNull K2, @NotNull V> {
    @NotNull
    private final @NotNull Map<@NotNull K1, @NotNull Map<@NotNull K2, V>> _map = new HashMap<K1, Map<K2, V>>();

    public void put(@NotNull K1 key1, @NotNull K2 key2, V value) {
        Map<@NotNull K2, V> map2 = this._map.get(key1);
        if (map2 == null) {
            map2 = new HashMap<K2, V>();
            this._map.put(key1, map2);
        }
        map2.put(key2, value);
    }

    public V getOrException(@NotNull K1 key1, @NotNull K2 key2) throws NullPointerException {
        @NotNull Map<@NotNull K2, V> map2 = this.getSubMapOrException(key1);
        if (!map2.containsKey(key2)) {
            throw new DeveloperNotificationException("Pfad (key1=" + String.valueOf(key1) + ", key2=" + String.valueOf(key2) + ") ung\u00fcltig!");
        }
        return map2.get(key2);
    }

    public V getOrNull(@NotNull K1 key1, @NotNull K2 key2) {
        Map<@NotNull K2, V> map2 = this._map.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.get(key2);
    }

    @NotNull
    public V getNonNullOrException(@NotNull K1 key1, @NotNull K2 key2) throws NullPointerException {
        V value = this.getOrException(key1, key2);
        if (value == null) {
            throw new DeveloperNotificationException("value is NULL!");
        }
        return value;
    }

    @NotNull
    public @NotNull Map<@NotNull K2, V> getSubMapOrException(@NotNull K1 key1) {
        Map<@NotNull K2, V> map2 = this._map.get(key1);
        if (map2 == null) {
            throw new DeveloperNotificationException("Pfad (key1=" + String.valueOf(key1) + ") ung\u00fcltig!");
        }
        return map2;
    }

    public Map<@NotNull K2, V> getSubMapOrNull(@NotNull K1 key1) {
        return this._map.get(key1);
    }

    public boolean contains(@NotNull K1 key1, @NotNull K2 key2) {
        Map<@NotNull K2, V> map2 = this._map.get(key1);
        if (map2 == null) {
            return false;
        }
        return map2.containsKey(key2);
    }

    public boolean containsKey1(@NotNull K1 key1) {
        return this._map.containsKey(key1);
    }

    public void clear() {
        this._map.clear();
    }

    public V removeOrException(@NotNull K1 key1, @NotNull K2 key2) {
        @NotNull Map<@NotNull K2, V> map2 = this.getSubMapOrException(key1);
        if (!map2.containsKey(key2)) {
            throw new DeveloperNotificationException("Pfad (key1=" + String.valueOf(key1) + ", key2=" + String.valueOf(key2) + ") ung\u00fcltig!");
        }
        V value = map2.remove(key2);
        if (map2.isEmpty()) {
            this._map.remove(key1);
        }
        return value;
    }

    public Map<@NotNull K2, V> removeSubMap(@NotNull K1 key1) {
        return this._map.remove(key1);
    }

    @NotNull
    public @NotNull Map<@NotNull K2, V> removeSubMapOrException(@NotNull K1 key1) {
        Map<@NotNull K2, V> value = this._map.remove(key1);
        if (value == null) {
            throw new DeveloperNotificationException("Pfad (key1=" + String.valueOf(key1) + ") existiert nicht!");
        }
        return value;
    }

    @NotNull
    public @NotNull List<@NotNull V> getNonNullValuesOfKey1AsList(@NotNull K1 key1) {
        @NotNull ArrayList<@NotNull V> list = new ArrayList<V>();
        for (V value : this.getSubMapOrException(key1).values()) {
            if (value == null) {
                throw new DeveloperNotificationException("Liste hat NULL Elemente!");
            }
            list.add(value);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull V> getNonNullValuesAsList() {
        @NotNull ArrayList<@NotNull V> list = new ArrayList<V>();
        for (Map<K2, V> map2 : this._map.values()) {
            for (V value : map2.values()) {
                if (value == null) {
                    throw new DeveloperNotificationException("Liste hat NULL Elemente!");
                }
                list.add(value);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull Set<@NotNull K1> getKeySet() {
        return this._map.keySet();
    }

    @NotNull
    public @NotNull Set<@NotNull K2> getKeySetOf(@NotNull K1 key1) {
        return this.getSubMapOrException(key1).keySet();
    }

    public int getSubMapSizeOrZero(@NotNull K1 key1) {
        Map<@NotNull K2, V> map2 = this._map.get(key1);
        if (map2 == null) {
            return 0;
        }
        return map2.size();
    }

    public int size() {
        int size = 0;
        for (Map<K2, V> map2 : this._map.values()) {
            size += map2.size();
        }
        return size;
    }
}

