/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.sat;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public final class SatInput {
    private int _nVars = 0;
    private int _varTRUE = 0;
    private int _varFALSE = 0;
    @NotNull
    private final @NotNull List<@NotNull Integer @NotNull []> _clauses = new ArrayList<Integer[]>();

    @NotNull
    public String toString() {
        return this.getDimacsHeader();
    }

    public int getVarTRUE() {
        if (this._varTRUE == 0) {
            this._varTRUE = this.create_var();
            this.add_clause_1(this._varTRUE);
        }
        return this._varTRUE;
    }

    public int getVarFALSE() {
        if (this._varFALSE == 0) {
            this._varFALSE = this.create_var();
            this.add_clause_1(-this._varFALSE);
        }
        return this._varFALSE;
    }

    public int getVarCount() {
        return this._nVars;
    }

    @NotNull
    public @NotNull List<@NotNull Integer @NotNull []> getClauses() {
        return this._clauses;
    }

    @NotNull
    public String getDimacsHeader() {
        return "p cnf " + this._nVars + " " + this._clauses.size();
    }

    public int create_var() {
        ++this._nVars;
        return this._nVars;
    }

    @NotNull
    public int[] create_vars1D(int n) {
        @NotNull int @NotNull [] temp = new int[n];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.create_var();
        }
        return temp;
    }

    @NotNull
    public @NotNull int @NotNull [][] create_vars2D(int rows, int cols) {
        @NotNull int @NotNull [] @NotNull [] temp = new int[rows][cols];
        for (int r = 0; r < rows; ++r) {
            temp[r] = this.create_vars1D(cols);
        }
        return temp;
    }

    public int create_var_AND(int x, int y) {
        int c = this.create_var();
        this.add_clause_2(x, -c);
        this.add_clause_2(y, -c);
        this.add_clause_3(-x, -y, c);
        return c;
    }

    public int create_var_OR(int x, int y) {
        int z = this.create_var();
        this.add_clause_2(-x, z);
        this.add_clause_2(-y, z);
        this.add_clause_3(x, y, -z);
        return z;
    }

    public int create_var_at_most_one_tree(@NotNull @NotNull LinkedCollection<@NotNull Integer> pList) {
        if (pList.isEmpty()) {
            return this.getVarFALSE();
        }
        @NotNull LinkedCollection<@NotNull Integer> list = new LinkedCollection<Integer>(pList);
        while (list.size() >= 2) {
            int a = list.removeFirst();
            int b = list.removeFirst();
            this.add_clause_not_both(a, b);
            int c = this.create_var_OR(a, b);
            list.addLast(c);
        }
        return list.removeFirst();
    }

    public void add_clause(@NotNull @NotNull Integer @NotNull [] pVars) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Die Klausel darf nicht leer sein!", pVars.length == 0);
        Integer[] integerArray = pVars;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int literal = integerArray[i];
            DeveloperNotificationException.ifTrue("Variable 0 ist nicht erlaubt!", literal == 0);
            int absL = Math.abs(literal);
            DeveloperNotificationException.ifTrue("Variable " + absL + " wurde vorher nicht erzeugt!", absL > this._nVars);
        }
        this._clauses.add(pVars);
    }

    public void add_clause_and_variables(@NotNull @NotNull Integer @NotNull [] pVars) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Die Klausel darf nicht leer sein!", pVars.length == 0);
        Integer[] integerArray = pVars;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int literal = integerArray[i];
            DeveloperNotificationException.ifTrue("Variable 0 ist nicht erlaubt!", literal == 0);
            int absL = Math.abs(literal);
            this._nVars = Math.max(this._nVars, absL);
        }
        this._clauses.add(pVars);
    }

    public void add_clause_1(int x) {
        this.add_clause(new Integer[]{x});
    }

    public void add_clause_2(int x, int y) {
        this.add_clause(new Integer[]{x, y});
    }

    public void add_clause_3(int x, int y, int z) {
        this.add_clause(new Integer[]{x, y, z});
    }

    public void add_clause_not_both(int x, int y) {
        this.add_clause_2(-x, -y);
    }

    public void add_clause_equal(int x, int y) {
        this.add_clause_2(-x, y);
        this.add_clause_2(x, -y);
    }

    public void add_clause_unequal(int x, int y) {
        this.add_clause_equal(x, -y);
    }

    public void add_clause_exactly(@NotNull int[] pArray, int pAmount) {
        @NotNull LinkedCollection<@NotNull Integer> list = new LinkedCollection<Integer>();
        for (int x : pArray) {
            list.addLast(x);
        }
        this.add_clause_exactly(list, pAmount);
    }

    public void add_clause_exactly(@NotNull @NotNull LinkedCollection<@NotNull Integer> pList, int pAmount) {
        @NotNull LinkedCollection<@NotNull Integer> list = new LinkedCollection<Integer>(pList);
        int size = list.size();
        DeveloperNotificationException.ifTrue("add_clause_exactly: " + pAmount + " > " + size, pAmount > size);
        if (pAmount == 0) {
            for (int x : list) {
                this.add_clause_1(-x);
            }
            return;
        }
        if (pAmount == size) {
            for (int x : list) {
                this.add_clause_1(x);
            }
            return;
        }
        if (pAmount == 1) {
            this.add_clause_exactly_one(list);
            return;
        }
        this._bitonic_exactly(list, pAmount);
    }

    public void add_clause_exactly_in_row(@NotNull @NotNull int @NotNull [] @NotNull [] pData, int pRow, int pAmount) {
        @NotNull LinkedCollection<@NotNull Integer> pList = new LinkedCollection<Integer>();
        for (int c = 0; c < pData[pRow].length; ++c) {
            pList.add(pData[pRow][c]);
        }
        this.add_clause_exactly(pList, pAmount);
    }

    public void add_clause_exactly_in_column(@NotNull @NotNull int @NotNull [] @NotNull [] pData, int pCol, int pAmount) {
        @NotNull LinkedCollection<@NotNull Integer> pList = new LinkedCollection<Integer>();
        for (int r = 0; r < pData.length; ++r) {
            pList.add(pData[r][pCol]);
        }
        this.add_clause_exactly(pList, pAmount);
    }

    private void add_clause_exactly_one(@NotNull @NotNull LinkedCollection<@NotNull Integer> pList) {
        int size = pList.size();
        if (size == 0) {
            this.add_clause_1(this.getVarFALSE());
            return;
        }
        if (size == 1) {
            this.add_clause_1(pList.getFirst());
            return;
        }
        if (size == 2) {
            this.add_clause_unequal(pList.getFirst(), pList.getLast());
            return;
        }
        int x = this.create_var_at_most_one_tree(pList);
        this.add_clause_1(x);
    }

    private void _bitonic_exactly(@NotNull @NotNull LinkedCollection<@NotNull Integer> list, int amount) {
        this._bitonic_sort(list);
        int i = 0;
        for (Integer value : list) {
            if (i < amount) {
                this.add_clause_1(value);
            } else {
                this.add_clause_1(-value.intValue());
            }
            ++i;
        }
    }

    private void _bitonic_sort(@NotNull @NotNull LinkedCollection<@NotNull Integer> list) {
        this._bitonic_fill_FALSE_until_power_two(list);
        this._bitonic_sort_power_two(list);
    }

    private void _bitonic_fill_FALSE_until_power_two(@NotNull @NotNull LinkedCollection<@NotNull Integer> list) {
        int size;
        for (size = 1; size < list.size(); size *= 2) {
        }
        while (list.size() < size) {
            list.addLast(this.getVarFALSE());
        }
    }

    private void _bitonic_sort_power_two(@NotNull @NotNull LinkedCollection<@NotNull Integer> list) {
        for (int window = 2; window <= list.size(); window *= 2) {
            this._bitonic_sort_spiral(list, window);
            for (int difference = window / 2; difference >= 2; difference /= 2) {
                this._bitonic_sort_difference(list, difference);
            }
        }
    }

    private void _bitonic_sort_spiral(@NotNull @NotNull LinkedCollection<@NotNull Integer> list, int size) {
        for (int i = 0; i < list.size(); i += size) {
            int i1 = i;
            for (int i2 = i + size - 1; i1 < i2; ++i1, --i2) {
                this._bitonic_comparator(list, i1, i2);
            }
        }
    }

    private void _bitonic_sort_difference(@NotNull @NotNull LinkedCollection<@NotNull Integer> list, int size) {
        int half = size / 2;
        for (int i = 0; i < list.size(); i += size) {
            for (int j = 0; j < half; ++j) {
                this._bitonic_comparator(list, i + j, i + j + half);
            }
        }
    }

    private void _bitonic_comparator(@NotNull @NotNull LinkedCollection<@NotNull Integer> result, int i1, int i2) {
        DeveloperNotificationException.ifTrue("c_bitonic_comparator: i1=" + i1 + " nicht kleiner als i2=" + i2 + "!", i1 >= i2);
        int a = result.get(i1);
        int b = result.get(i2);
        result.set(i1, this.create_var_OR(a, b));
        result.set(i2, this.create_var_AND(a, b));
    }

    public boolean isValidSolution(@NotNull @NotNull int @NotNull [] solution) {
        DeveloperNotificationException.ifTrue("Arraygr\u00f6\u00dfe " + solution.length + " passt nicht zur Variablenanzahl " + this._nVars + "!", solution.length != this._nVars + 1);
        for (Integer[] clause : this._clauses) {
            int countTRUE = 0;
            Integer[] integerArray = clause;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                @NotNull int literal = integerArray[i];
                int abs = Math.abs(literal);
                int assignment = solution[abs];
                DeveloperNotificationException.ifTrue("x_" + abs + " == 0", assignment == 0);
                if (assignment != literal) continue;
                ++countTRUE;
            }
            if (countTRUE != 0) continue;
            return false;
        }
        return true;
    }
}

