/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.sat;

import jakarta.validation.constraints.NotNull;

public final class SatOutput {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_SATISFIABLE = 1;
    public static final int TYPE_UNSATISFIABLE = 2;
    @NotNull
    private final int[] solution;
    private final int type;

    private SatOutput(@NotNull int[] pSolution, int pType) {
        this.solution = pSolution;
        this.type = pType;
    }

    @NotNull
    public int[] getSolution() {
        return this.solution;
    }

    public boolean isSatisfiable() {
        return this.type == 1;
    }

    public boolean isUnsatisfiable() {
        return this.type == 2;
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    @NotNull
    public static SatOutput createUNKNOWN() {
        return new SatOutput(new int[0], 0);
    }

    @NotNull
    public static SatOutput createUNSATISFIABLE() {
        return new SatOutput(new int[0], 2);
    }

    @NotNull
    public static SatOutput createSATISFIABLE(@NotNull int[] pSolution) {
        return new SatOutput(pSolution, 1);
    }

    @NotNull
    public static SatOutput createCopy(@NotNull SatOutput pOutput, @NotNull int[] pSolution) {
        return new SatOutput(pSolution, pOutput.type);
    }
}

