/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.sat;

import de.svws_nrw.core.adt.sat.SatInput;
import de.svws_nrw.core.adt.sat.SatOutput;
import de.svws_nrw.core.adt.sat.SatSolver;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public final class SatSolverSimple1
extends SatSolver {
    @NotNull
    private final @NotNull List<@NotNull Integer @NotNull []> _clauses = new ArrayList<Integer[]>();
    @NotNull
    private int[] _solution = new int[0];

    @Override
    @NotNull
    public SatOutput apply(@NotNull SatInput t) {
        long timeEnd = System.currentTimeMillis() + this.maxTimeMillis;
        int nVars = t.getVarCount();
        DeveloperNotificationException.ifSmaller("nVars", nVars, 1L);
        this._clauses.clear();
        this._clauses.addAll(t.getClauses());
        this._solution = new int[nVars + 1];
        int i = 1;
        while (System.currentTimeMillis() <= timeEnd) {
            if (this.conflict()) {
                while (true) {
                    if (--i < 1) {
                        return SatOutput.createUNSATISFIABLE();
                    }
                    if (this._solution[i] != -i) break;
                    this._solution[i] = 0;
                }
            }
            if (i >= this._solution.length) {
                return SatOutput.createSATISFIABLE(this._solution);
            }
            this._solution[i] = this._solution[i] == 0 ? i : -i;
            ++i;
        }
        return SatOutput.createUNKNOWN();
    }

    private boolean conflict() {
        for (Integer[] clause : this._clauses) {
            if (!this.isEmpty(clause)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(@NotNull @NotNull Integer @NotNull [] clause) {
        Integer[] integerArray = clause;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int literal = integerArray[i];
            int abs = Math.abs(literal);
            int assignment = this._solution[abs];
            if (assignment != literal && assignment != 0) continue;
            return false;
        }
        return true;
    }
}

