/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.sat;

import de.svws_nrw.core.adt.sat.SatInput;
import de.svws_nrw.core.adt.sat.SatOutput;
import jakarta.validation.constraints.NotNull;
import java.util.Random;
import java.util.function.Function;

public final class SatWrapper1
implements Function<SatInput, SatOutput> {
    @NotNull
    private final @NotNull Function<@NotNull SatInput, @NotNull SatOutput> next;
    @NotNull
    private final Random rnd = new Random();

    public SatWrapper1(@NotNull @NotNull Function<@NotNull SatInput, @NotNull SatOutput> next) {
        this.next = next;
    }

    @Override
    @NotNull
    public SatOutput apply(@NotNull SatInput in1) {
        int nVars = in1.getVarCount();
        @NotNull int[] map1to2 = new int[nVars + 1];
        for (int i = 1; i <= nVars; ++i) {
            map1to2[i] = i;
        }
        for (int i1 = 1; i1 <= nVars; ++i1) {
            int save2;
            int i2 = this.rnd.nextInt(nVars) + 1;
            int save1 = map1to2[i1];
            map1to2[i1] = save2 = map1to2[i2];
            map1to2[i2] = save1;
        }
        @NotNull SatInput in2 = new SatInput();
        for (Integer[] clause : in1.getClauses()) {
            @NotNull Integer @NotNull [] clause2 = new Integer[clause.length];
            for (int i = 0; i < clause.length; ++i) {
                int lit = clause[i];
                clause2[i] = lit >= 0 ? map1to2[lit] : -map1to2[-lit];
            }
            in2.add_clause_and_variables(clause2);
        }
        @NotNull SatOutput out2 = this.next.apply(in2);
        @NotNull int[] solution2 = out2.getSolution();
        @NotNull int[] solution1 = new int[solution2.length];
        for (int lit1 = 1; lit1 < solution2.length; ++lit1) {
            int lit2 = map1to2[lit1];
            solution1[lit1] = solution2[lit2] >= 0 ? lit1 : -lit1;
        }
        return SatOutput.createCopy(out2, solution1);
    }
}

