/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.set;

import de.svws_nrw.core.adt.map.AVLMap;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;

public final class AVLSet<@NotNull E>
implements NavigableSet<E> {
    @NotNull
    private final @NotNull NavigableSet<@NotNull E> _set;

    public AVLSet() {
        @NotNull AVLMap<@NotNull K, @NotNull V> map = new AVLMap();
        map.allowKeyAlone(true);
        this._set = map.navigableKeySet();
    }

    public AVLSet(@NotNull @NotNull Comparator<@NotNull E> comparator) {
        @NotNull AVLMap<@NotNull E, @NotNull V> map = new AVLMap(comparator);
        map.allowKeyAlone(true);
        this._set = map.navigableKeySet();
    }

    public AVLSet(@NotNull @NotNull SortedSet<@NotNull E> set) {
        @NotNull AVLMap<@NotNull K, @NotNull V> map = new AVLMap();
        map.allowKeyAlone(true);
        this._set = map.navigableKeySet();
        this._set.addAll(set);
    }

    @Override
    @NotNull
    public @NotNull Comparator<? super @NotNull E> comparator() {
        return this._set.comparator();
    }

    @Override
    @NotNull
    public E first() {
        return this._set.first();
    }

    @Override
    @NotNull
    public E last() {
        return this._set.last();
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    @Override
    public boolean contains(@NotNull Object o) {
        return this._set.contains(o);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this._set.toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this._set.toArray(a);
    }

    @Override
    public boolean add(@NotNull E e) {
        return this._set.add(e);
    }

    @Override
    public boolean remove(@NotNull Object o) {
        return this._set.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._set.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull @NotNull Collection<? extends @NotNull E> c) {
        return this._set.addAll(c);
    }

    @Override
    public boolean retainAll(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._set.retainAll(c);
    }

    @Override
    public boolean removeAll(@NotNull @NotNull Collection<@NotNull ?> c) {
        return this._set.removeAll(c);
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public E lower(@NotNull E e) {
        return this._set.lower(e);
    }

    @Override
    public E floor(@NotNull E e) {
        return this._set.floor(e);
    }

    @Override
    public E ceiling(@NotNull E e) {
        return this._set.ceiling(e);
    }

    @Override
    public E higher(@NotNull E e) {
        return this._set.higher(e);
    }

    @Override
    public E pollFirst() {
        return this._set.pollFirst();
    }

    @Override
    public E pollLast() {
        return this._set.pollLast();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull E> iterator() {
        return this._set.iterator();
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull E> descendingSet() {
        return this._set.descendingSet();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull E> descendingIterator() {
        return this._set.descendingIterator();
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull E> subSet(@NotNull E fromElement, boolean fromInclusive, @NotNull E toElement, boolean toInclusive) {
        return this._set.subSet(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull E> headSet(@NotNull E toElement, boolean inclusive) {
        return this._set.headSet(toElement, inclusive);
    }

    @Override
    @NotNull
    public @NotNull NavigableSet<@NotNull E> tailSet(@NotNull E fromElement, boolean inclusive) {
        return this._set.tailSet(fromElement, inclusive);
    }

    @Override
    @NotNull
    public @NotNull SortedSet<@NotNull E> subSet(@NotNull E fromElement, @NotNull E toElement) {
        return this._set.subSet(fromElement, toElement);
    }

    @Override
    @NotNull
    public @NotNull SortedSet<@NotNull E> headSet(@NotNull E toElement) {
        return this._set.headSet(toElement);
    }

    @Override
    @NotNull
    public @NotNull SortedSet<@NotNull E> tailSet(@NotNull E fromElement) {
        return this._set.tailSet(fromElement);
    }
}

