/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.tree;

import de.svws_nrw.core.adt.tree.MinHeapIterator;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public final class MinHeap<@NotNull T>
implements Queue<T> {
    private int _size = 0;
    @NotNull
    private T[] _nodes = new Object[0];
    @NotNull
    private final @NotNull Comparator<@NotNull T> _comparator;
    private final int _initialCapacity;
    protected int _modCount;

    public MinHeap(@NotNull @NotNull Comparator<@NotNull T> comparator, int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Die initiale Kapazit\u00e4t muss gr\u00f6\u00dfer als 0 sein.");
        }
        this._comparator = comparator;
        this._initialCapacity = initialCapacity;
        this._modCount = 0;
    }

    public MinHeap(@NotNull @NotNull Comparator<@NotNull T> comparator) {
        this._comparator = comparator;
        this._initialCapacity = 63;
        this._modCount = 0;
    }

    public MinHeap(@NotNull @NotNull MinHeap<@NotNull T> original) {
        this._comparator = original._comparator;
        this._initialCapacity = original._initialCapacity;
        this._nodes = Arrays.copyOf(original._nodes, original._nodes.length);
        this._size = original._size;
        this._modCount = original._modCount;
    }

    @Override
    public boolean add(@NotNull T e) throws IllegalStateException {
        if (e == null) {
            return false;
        }
        if (this._nodes.length == 0) {
            this._nodes = this.newArray(e, this._initialCapacity);
        }
        if (this._size == this._nodes.length) {
            this.grow();
        }
        this._nodes[this._size] = e;
        this.heapifyUp(this._size++);
        ++this._modCount;
        return true;
    }

    @Override
    @NotNull
    public T element() {
        if (this._size == 0 || this._nodes[0] == null) {
            throw new NoSuchElementException();
        }
        return this._nodes[0];
    }

    @Override
    public boolean offer(@NotNull T e) {
        return this.add(e);
    }

    @Override
    public T peek() {
        return this._nodes.length == 0 ? null : (T)this._nodes[0];
    }

    @Override
    public T poll() {
        if (this._size == 0) {
            return null;
        }
        T elem = this._nodes[0];
        this._nodes[0] = this._nodes[--this._size];
        this._nodes[this._size] = null;
        this.heapifyDown(0);
        ++this._modCount;
        return elem;
    }

    @Override
    @NotNull
    public T remove() {
        T result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (!this._nodes[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            return true;
        }
        if (this == c) {
            return true;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends @NotNull T> c) throws IllegalStateException {
        if (c == null) {
            return false;
        }
        if (this == c) {
            T[] tmp;
            if (this._size == 0) {
                return false;
            }
            for (T t : tmp = Arrays.copyOf(this._nodes, this._size)) {
                if (t == null) continue;
                this.add(t);
            }
            return true;
        }
        boolean result = false;
        for (T t : c) {
            if (!this.add(t)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        int index = this.findIndex(o);
        if (index == -1) {
            return false;
        }
        --this._size;
        ++this._modCount;
        if (index == this._size) {
            return true;
        }
        this._nodes[index] = this._nodes[this._size];
        this._nodes[this._size] = null;
        this.heapifyUp(index);
        this.heapifyDown(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        if (this == c) {
            if (this.size() == 0) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean result = false;
        for (Object o : c) {
            while (this.remove(o)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        T elem;
        if (this._size == 0) {
            return false;
        }
        if (c == null) {
            this.clear();
            return true;
        }
        if (this == c) {
            return false;
        }
        @NotNull T[] tmp = this.newArray(this._nodes[0], this._nodes.length);
        if (tmp == null) {
            return false;
        }
        int i = 0;
        boolean changed = false;
        while ((elem = this.poll()) != null) {
            if (c.contains(elem)) {
                tmp[i++] = elem;
                continue;
            }
            changed = true;
        }
        this._nodes = tmp;
        this._size = i;
        ++this._modCount;
        return changed;
    }

    @Override
    public void clear() {
        this._nodes = new Object[0];
        this._size = 0;
        ++this._modCount;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.copyNodes();
    }

    @Override
    @NotNull
    public <U> @NotNull U @NotNull [] toArray(@NotNull @NotNull U @NotNull [] a) {
        if (a.length < this._size) {
            return this.copyNodes();
        }
        System.arraycopy(this._nodes, 0, a, 0, this._size);
        Arrays.fill(a, this._size, a.length, null);
        return a;
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull T> iterator() {
        return new MinHeapIterator<T>(this._nodes, this);
    }

    @NotNull
    public @NotNull Comparator<@NotNull T> comparator() {
        return this._comparator;
    }

    public int capacity() {
        return this._nodes.length == 0 ? this._initialCapacity : this._nodes.length;
    }

    @NotNull
    public @NotNull T @NotNull [] toSortedArray() {
        T current;
        if (this._size == 0) {
            return new Object[0];
        }
        @NotNull MinHeap<@NotNull T> copy = new MinHeap<T>(this);
        @NotNull T @NotNull [] tmp = this.newArray(this._nodes[0], this._size);
        int i = 0;
        while ((current = copy.poll()) != null) {
            tmp[i++] = current;
        }
        return tmp;
    }

    @NotNull
    public String toString() {
        @NotNull StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._size; ++i) {
            sb.append(this._nodes[i]);
            if (i == this._size - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode(this.toSortedArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MinHeap) {
            MinHeap other = (MinHeap)obj;
            return Arrays.deepEquals(this.toSortedArray(), other.toSortedArray());
        }
        return false;
    }

    private static int getParentIndex(int i) {
        return i <= 0 ? -1 : (i - 1) / 2;
    }

    private static int getLeftChildIndex(int i) {
        return 2 * i + 1;
    }

    private static int getRightChildIndex(int i) {
        return 2 * i + 2;
    }

    private void swap(int i, int j) {
        T elem = this._nodes[i];
        this._nodes[i] = this._nodes[j];
        this._nodes[j] = elem;
    }

    private void heapifyDown(int i) {
        int left = MinHeap.getLeftChildIndex(i);
        int right = MinHeap.getRightChildIndex(i);
        if (left >= this._size) {
            return;
        }
        int child = right;
        if (right == this._size) {
            child = left;
        } else {
            T nodeLeft = this._nodes[left];
            T nodeRight = this._nodes[right];
            if (nodeLeft == null || nodeRight == null) {
                return;
            }
            if (this._comparator.compare(nodeLeft, nodeRight) < 0) {
                child = left;
            }
        }
        T nodeCurrent = this._nodes[i];
        T nodeChild = this._nodes[child];
        if (nodeCurrent == null || nodeChild == null) {
            throw new NullPointerException();
        }
        if (this._comparator.compare(nodeCurrent, nodeChild) <= 0) {
            return;
        }
        this.swap(i, child);
        this.heapifyDown(child);
    }

    private void heapifyUp(int i) {
        int parentIndex = MinHeap.getParentIndex(i);
        if (parentIndex < 0) {
            return;
        }
        T nodeCurrent = this._nodes[i];
        T nodeParent = this._nodes[parentIndex];
        if (nodeCurrent == null || nodeParent == null || this._comparator.compare(nodeCurrent, nodeParent) >= 0) {
            return;
        }
        this.swap(i, parentIndex);
        this.heapifyUp(parentIndex);
    }

    @NotNull
    private @NotNull T @NotNull [] newArray(T elem, int length) {
        if (elem == null) {
            return (Object[])Array.newInstance(Object.class, length);
        }
        return (Object[])Array.newInstance(elem.getClass(), length);
    }

    @NotNull
    private @NotNull T @NotNull [] copyNodes() {
        @NotNull Object @NotNull [] result = this.newArray(this._size <= 0 ? null : (T)this._nodes[0], this._size);
        System.arraycopy(this._nodes, 0, result, 0, this._size);
        return result;
    }

    private void grow() throws IllegalStateException {
        if (this._nodes.length == Integer.MAX_VALUE) {
            throw new IllegalStateException("Der Minimum-Heap kann nicht mehr als 2147483647 Elemente beinhalten.");
        }
        int newLength = this._nodes.length * 2 + 1;
        if (newLength < 0) {
            newLength = Integer.MAX_VALUE;
        }
        @NotNull T @NotNull [] tmp = this.newArray(this._nodes[0], newLength);
        System.arraycopy(this._nodes, 0, tmp, 0, this._size);
        this._nodes = tmp;
    }

    private int findIndex(Object obj) {
        if (obj == null) {
            return -1;
        }
        for (int i = 0; i < this._size; ++i) {
            if (!this._nodes[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    int getModCount() {
        return this._modCount;
    }
}

