/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.adt.tree;

import de.svws_nrw.core.adt.tree.MinHeap;
import jakarta.validation.constraints.NotNull;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class MinHeapIterator<@NotNull T>
implements Iterator<T> {
    @NotNull
    private final T[] _elements;
    private int _current = -1;
    @NotNull
    private final @NotNull MinHeap<@NotNull T> _heap;
    private final int _expModCount;

    MinHeapIterator(@NotNull T[] elem, @NotNull @NotNull MinHeap<@NotNull T> heap) {
        this._elements = elem;
        this._heap = heap;
        this._expModCount = heap.getModCount();
    }

    @Override
    public boolean hasNext() {
        if (this._heap.getModCount() != this._expModCount) {
            throw new ConcurrentModificationException();
        }
        return this._current + 1 < this._heap.size();
    }

    @Override
    @NotNull
    public T next() {
        T elem;
        if (!this.hasNext()) {
            throw new NoSuchElementException("Keine weiteren Elemente vorhanden. Eine Pr\u00fcfung mit hasNext() vorab ist empfehlenswert.");
        }
        if ((elem = this._elements[++this._current]) == null) {
            throw new NoSuchElementException("Interner Fehler in der Datenstruktur.");
        }
        return elem;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

