/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.adressbuch;

import de.svws_nrw.core.data.adressbuch.AdressbuchEintrag;
import de.svws_nrw.core.data.adressbuch.Telefonnummer;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Ein Kontakt in einem Adressbuch.")
@TranspilerDTO
public class AdressbuchKontakt
extends AdressbuchEintrag {
    @Schema(description="der Nachname", example="Mustermann")
    @NotNull
    public String nachname = "";
    @Schema(description="der Vorname", example="Max")
    @NotNull
    public String vorname = "";
    @Schema(description="der Stra\u00dfenname des Kontakts.", example="Musterweg")
    public String strassenname;
    @Schema(description="Ggf. die Hausnummer des Kontakts.", example="4711")
    public String hausnummer;
    @Schema(description="Ggf. der Hausnummerzusatz des Kontakts.", example="a-d")
    public String hausnummerZusatz;
    @Schema(description="die Postleitzahl des Kontakts", example="42287")
    public String plz;
    @Schema(description="der Ort des Kontakts", example="D\u00fcsseldorf")
    public String ort;
    @ArraySchema(schema=@Schema(description="Die Telefonnummern des Kontakts. ", example="..."))
    @NotNull
    public @NotNull List<@NotNull Telefonnummer> telefonnummern = new ArrayList<Telefonnummer>();
    @Schema(description="die Mailadresse des Kontakts", example="info@schule.de")
    public String email;
    @Schema(description="die Adresse der Homepage des Kontakts", example="www.schule.de")
    public String webAdresse = "";
    @ArraySchema(schema=@Schema(description="Die Kategorien dieses Kontakts", example="..."))
    public List<String> kategorien = new ArrayList<String>();
    @Schema(description="die Organisation des Kontakts", example="Sophie-Scholl-Gymnasium")
    public String organisation;
    @Schema(description="Die Rolle innerhalb der Organisation des Kontakts", example="Sch\u00fcler")
    public String rolle;
    @Schema(description="Die ID des Adressbuchkontakts des Kinds", example="Schueler_1234")
    public String idKind;
    @Schema(description="Die ID des Adressbuchkontakts der Eltern", example="Erzieher_1234")
    public String idEltern;
}

