/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.benutzer;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.benutzer.BenutzerKompetenzGruppe;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag im Katalog der Benutzerkompetenzen.")
@TranspilerDTO
public class BenutzerKompetenzKatalogEintrag {
    @Schema(description="die ID der Benutzerkompetenz", example="11")
    public long id = -1L;
    @Schema(description="die ID der zugeh\u00f6rigen Benutzerkompetenzgruppe", example="100")
    @NotNull
    public long gruppe_id = -1L;
    @Schema(description="die Bezeichnung der Benutzerkompetenz", example="Ansehen")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="die Schulformen, bei denen die Kompetenz zul\u00e4ssig ist", example="Liste")
    public List<@NotNull Long> nurSchulformen = null;

    public BenutzerKompetenzKatalogEintrag() {
    }

    public BenutzerKompetenzKatalogEintrag(long id, @NotNull BenutzerKompetenzGruppe gruppe, @NotNull String bezeichnung, List<@NotNull Schulform> schulformen) {
        this.id = id;
        this.bezeichnung = bezeichnung;
        this.gruppe_id = gruppe.daten.id;
        if (schulformen != null) {
            this.nurSchulformen = new ArrayList<Long>();
            for (Schulform schulform : schulformen) {
                this.nurSchulformen.add(schulform.daten.id);
            }
        }
    }
}

