/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.enm;

import de.svws_nrw.core.data.enm.ENMFach;
import de.svws_nrw.core.data.enm.ENMFloskelgruppe;
import de.svws_nrw.core.data.enm.ENMFoerderschwerpunkt;
import de.svws_nrw.core.data.enm.ENMJahrgang;
import de.svws_nrw.core.data.enm.ENMKlasse;
import de.svws_nrw.core.data.enm.ENMLehrer;
import de.svws_nrw.core.data.enm.ENMLerngruppe;
import de.svws_nrw.core.data.enm.ENMNote;
import de.svws_nrw.core.data.enm.ENMSchueler;
import de.svws_nrw.core.data.enm.ENMTeilleistungsart;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Spezifiziert die grundlegende Struktur von JSON-Daten f\u00fcr das Externe-Noten-Modul ENM.")
@TranspilerDTO
public class ENMDaten {
    @Schema(description="Die Revision des ENM-Datenformates, um zu \u00fcberpr\u00fcfen, ob die Datei in dem richtigen Format vorliegt (-1 f\u00fcr Entwickler-Revisionen und ansonsten aufsteigend ab 1.", example="1")
    public int enmRevision = -1;
    @Schema(description="Die Schulnummer, f\u00fcr welche die ENM-Daten generiert wurden.", example="100815")
    public int schulnummer;
    @Schema(description="Das Schuljahr, f\u00fcr welches die ENM-Daten generiert wurden.", example="2021")
    public int schuljahr;
    @Schema(description="Die Anzahl der Abschnitte an der Schule (2: Halbjahrsmodus, 4: Quartalsmodus)", example="2")
    public int anzahlAbschnitte;
    @Schema(description="Gibt an, f\u00fcr welchen Abschnitt innerhalb des Schuljahres die ENM-Daten generiert wurden.", example="2")
    public int aktuellerAbschnitt;
    @Schema(description="Gibt den \u00f6ffentlichen Schl\u00fcssel an, welcher f\u00fcr die Verschl\u00fcsselung und den R\u00fcckversand der Datei genutzt werden soll.", example="")
    public String publicKey;
    @Schema(description="Gibt die SVWS-ID des Lehrers an, f\u00fcr den die externe Notendatei generiert wurde. Ist die ID = NULL, enth\u00e4lt das Objekt alle Lehrerdaten.", example="42")
    public Long lehrerID;
    @Schema(description="Gibt an, ob die Fehlstunden-Eingabe durch das externe Notenmodul erlaubt ist oder nicht. ", example="true")
    public boolean fehlstundenEingabe;
    @Schema(description="Gibt an, ob die Fehlstunden f\u00fcr die Sekundarstufe I fachbezogen eingetragen werden oder nicht.", example="false")
    public boolean fehlstundenSIFachbezogen;
    @Schema(description="Gibt an, ob die Fehlstunden f\u00fcr die Sekundarstufe II fachbezogen eingetragen werden oder nicht.", example="true")
    public boolean fehlstundenSIIFachbezogen;
    @Schema(description="Gibt das K\u00fcrzel der Schulform der Schule an.", example="GY")
    public String schulform;
    @Schema(description="Gibt die Mailadresse an, an welche die verschl\u00fcsselte Datei zur\u00fcckgesendet werden soll.", example="mail@schule.nrw.de")
    public String mailadresse;
    @Schema(description="Ein Array mit den g\u00fcltigen Katalog-Eintr\u00e4gen f\u00fcr Noten (als \u00dcbersicht f\u00fcr das ENM-Client-Tool).")
    @NotNull
    public @NotNull List<@NotNull ENMNote> noten = new ArrayList<ENMNote>();
    @Schema(description="Der Katalog mit den g\u00fcltigen Eintr\u00e4gen von F\u00f6rderschwerpunkten (als \u00dcbersicht f\u00fcr das ENM-Tool).")
    @NotNull
    public @NotNull List<@NotNull ENMFoerderschwerpunkt> foerderschwerpunkte = new ArrayList<ENMFoerderschwerpunkt>();
    @ArraySchema(schema=@Schema(implementation=ENMJahrgang.class, description="Ein Array mit den Informationen zu den einzelnen Jahrg\u00e4ngen, die in der Notendatei enthalten sind."))
    @NotNull
    public @NotNull List<@NotNull ENMJahrgang> jahrgaenge = new ArrayList<ENMJahrgang>();
    @ArraySchema(schema=@Schema(implementation=ENMKlasse.class, description="Ein Array mit den Informationen zu den einzelnen Klassen, die in der Notendatei enthalten sind."))
    @NotNull
    public @NotNull List<@NotNull ENMKlasse> klassen = new ArrayList<ENMKlasse>();
    @ArraySchema(schema=@Schema(implementation=ENMFloskelgruppe.class, description="Ein Array mit den Informationen der vordefinierten Floskelgruppen und deren Floskeln."))
    @NotNull
    public @NotNull List<@NotNull ENMFloskelgruppe> floskelgruppen = new ArrayList<ENMFloskelgruppe>();
    @ArraySchema(schema=@Schema(implementation=ENMLehrer.class, description="Ein Array mit den Informationen zu Lehrern, die in der Notendatei vorhanden sind."))
    @NotNull
    public @NotNull List<@NotNull ENMLehrer> lehrer = new ArrayList<ENMLehrer>();
    @ArraySchema(schema=@Schema(implementation=ENMFach.class, description="Ein Array mit den Informationen zu den F\u00e4chern, die in der Notendatei vorhanden sind."))
    @NotNull
    public @NotNull List<@NotNull ENMFach> faecher = new ArrayList<ENMFach>();
    @ArraySchema(schema=@Schema(implementation=ENMTeilleistungsart.class, description="Ein Array mit den Informationen zu den Teilleistungsarten, die in der Notendatei vorhanden sind."))
    @NotNull
    public @NotNull List<@NotNull ENMTeilleistungsart> teilleistungsarten = new ArrayList<ENMTeilleistungsart>();
    @ArraySchema(schema=@Schema(implementation=ENMLerngruppe.class, description="Ein Array mit den Informationen zu den Lerngruppen (Klassen und Kurse), die in der Notendatei vorhanden sind."))
    @NotNull
    public @NotNull List<@NotNull ENMLerngruppe> lerngruppen = new ArrayList<ENMLerngruppe>();
    @ArraySchema(schema=@Schema(implementation=ENMSchueler.class, description="Ein Array mit den Informationen zu den Sch\u00fclern, deren Noten in dieser Notendatei verwaltet werden."))
    @NotNull
    public @NotNull List<@NotNull ENMSchueler> schueler = new ArrayList<ENMSchueler>();
}

