/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.enm;

import de.svws_nrw.core.data.enm.ENMTeilleistung;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Spezifiziert die Struktur von JSON-Daten zu den Leistungsdaten eines Sch\u00fcler in Bezug auf den Lernabschnitt f\u00fcr das Externe-Noten-Modul ENM.")
@TranspilerDTO
public class ENMLeistung {
    @Schema(description="Die ID der Leistungsdaten des Sch\u00fclers in der SVWS-DB.", example="307956")
    public long id;
    @Schema(description="Die eindeutige ID der Lerngruppe, der der Sch\u00fcler zugeordnet ist. (Klasse oder Kurs wird erst.in der Lerngruppe unterschieden!)", example="12345")
    public long lerngruppenID;
    @Schema(description="Das K\u00fcrzel der Note, die vergeben wurde.", example="3+")
    public String note;
    @Schema(description="Der Zeitstempel der letzten \u00c4nderung an der erteilten Note.", example="2013-11-14 13:12:48.774")
    public String tsNote;
    @Schema(description="Das K\u00fcrzel der Quartals-Note, die vergeben wurde.", example="3+")
    public String noteQuartal;
    @Schema(description="Der Zeitstempel der letzten \u00c4nderung an der erteilten Quartals-Note.", example="2013-11-14 13:12:48.774")
    public String tsNoteQuartal;
    @Schema(description="Gibt bei Oberstufenkursen an, ob das Fach schriftlich belegt wurde oder nicht.", example="true")
    public Boolean istSchriftlich;
    @Schema(description="Gibt an, ob es sich um ein Abitufach handelt (1,2,3 oder 4) oder nicht (null).", example="2")
    public Integer abiturfach;
    @Schema(description="Gibt die Anzahl der gesamten Fehlstunden an, sofern diese fachbezogen ermittel werden.", example="23")
    public Integer fehlstundenFach;
    @Schema(description="Der Zeitstempel der letzten \u00c4nderung an Anzahl der gesamten Fehlstunden an, sofern diese fachbezogen ermittelt werden.", example="2013-11-14 13:12:48.774")
    public String tsFehlstundenFach;
    @Schema(description="Gibt die Anzahl der unentschuldigten Fehlstunden an, sofern diese fachbezogen ermittel werden.", example="0")
    public Integer fehlstundenUnentschuldigtFach;
    @Schema(description="Der Zeitstempel der letzten \u00c4nderung an Anzahl der unentschuldigten Fehlstunden an, sofern diese fachbezogen ermittelt werden.", example="2013-11-14 13:12:48.774")
    public String tsFehlstundenUnentschuldigtFach;
    @Schema(description="Die fachbezogenen Bemerkungen bzw. das Thema bei Projektkursen.", example="Text zum Fach")
    public String fachbezogeneBemerkungen;
    @Schema(description="Der Zeitstempel der letzten \u00c4nderung an Anzahl den fachbezogenen Bemerkungen bzw. dem Thema bei Projektkursen.", example="2013-11-14 13:12:48.774")
    public String tsFachbezogeneBemerkungen;
    @Schema(description="Die Kurszuweisung, die auf dem Zeugnis erscheinen soll f\u00fcr den n\u00e4chsten Kursabschnitt (z.B. E oder G-Kurs, z.B. an der Gesamtschule).", example="E")
    public String neueZuweisungKursart;
    @Schema(description="Gibt an, ob ein Fach gemahnt wurde oder nicht.", example="true")
    public Boolean istGemahnt;
    @Schema(description="Der Zeitstempel, wann gesetzt wurde, ob die Leistung gemahnt wurde.", example="2013-11-14 13:12:48.774")
    public String tsIstGemahnt;
    @Schema(description="Das Mahndatum bei erfolgter Mahnung.", example="11.11.1911")
    public String mahndatum;
    @ArraySchema(schema=@Schema(implementation=ENMTeilleistung.class, description="Ein Array mit den Informationen zu den Teilleistungen, sofern welche vordefiniert sind."))
    @NotNull
    public @NotNull List<@NotNull ENMTeilleistung> teilleistungen = new ArrayList<ENMTeilleistung>();
}

