/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.enm;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Spezifiziert die Struktur von JSON-Daten zu Lerngruppen in Bezug auf den Lernabschnitt f\u00fcr das Externe-Noten-Modul ENM.")
@TranspilerDTO
public class ENMLerngruppe {
    @Schema(description="Die eindeutige ID der Lerngruppe - generiert, nicht (!) aus der SVWS-DB.", example="12345")
    public long id;
    @Schema(description="Die ID der Lerngruppe in der SVWS-DB (Die ID des Kurses oder die ID der Klasse in der Versetzungstabelle, siehe kursartID).", example="1234")
    public long kID;
    @Schema(description="Die ID des Faches der Lerngruppe.", example="123")
    public long fachID;
    @Schema(description="Gibt die ID der Kursart an. Ist dieser Wert null, so handelt es sich um Klassen-Unterricht.", example="PUT")
    public Integer kursartID;
    @Schema(description="Die Bezeichnung der Lerngruppe.", example="D-GK4")
    public String bezeichnung;
    @Schema(description="Das K\u00fcrzel der (allgemeinen) Kursart.", example="GK")
    public String kursartKuerzel;
    @Schema(description="Das einstellige K\u00fcrzel der bilingualen Sprache, sofern es sich um eine bilinguale Lerngruppe handelt.", example="F")
    public String bilingualeSprache;
    @ArraySchema(schema=@Schema(implementation=Long.class, description="Ein Array mit den Informationen zu den IDs der Lehrer, die der Lerngruppe zugeordnet sind."))
    @NotNull
    public @NotNull List<@NotNull Long> lehrerID = new ArrayList<Long>();
    @Schema(description="Die Anzahl der Wochenstunden, falls es sich um einen Kurs handelt.", example="3")
    public int wochenstunden;
}

