/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.enm;

import de.svws_nrw.core.data.enm.ENMBKAbschluss;
import de.svws_nrw.core.data.enm.ENMLeistung;
import de.svws_nrw.core.data.enm.ENMLeistungBemerkungen;
import de.svws_nrw.core.data.enm.ENMLernabschnitt;
import de.svws_nrw.core.data.enm.ENMSprachenfolge;
import de.svws_nrw.core.data.enm.ENMZP10;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Spezifiziert die Struktur von JSON-Daten zu den Sch\u00fclern in Bezug auf den Lernabschnitt f\u00fcr das Externe-Noten-Modul ENM.")
@TranspilerDTO
public class ENMSchueler {
    @Schema(description="Die ID des Sch\u00fclers in der SVWS-DB", example="12345")
    public long id;
    @Schema(description="Die ID des aktuellen Jahrgangs, in dem sich der Sch\u00fcler befindet", example="13")
    public long jahrgangID;
    @Schema(description="Die ID der aktuellen Klasse, in der sich der Sch\u00fcler befindet", example="42")
    public long klasseID;
    @Schema(description="Der Nachname des Sch\u00fclers", example="Mustermann")
    public String nachname;
    @Schema(description="Der Vorname des Sch\u00fclers", example="Max")
    public String vorname;
    @Schema(description="Das Geschlecht des Sch\u00fclers (m - m\u00e4nnlich, w - weiblich, d - divers, x - ohne Angabe im Geburtenregister)", example="d")
    public String geschlecht;
    @Schema(description="Gibt an, ob sich der Sch\u00fcler aktuell im bilingualen Bildungsgang befindet (wenn ja, z.B. F) oder nicht (null)", example="null")
    public String bilingualeSprache;
    @Schema(description="Gibt an, ob der Sch\u00fcler Ziel-different unterrichtet wird", example="false")
    public boolean istZieldifferent;
    @Schema(description="Gibt an, ob der Sch\u00fcler Deutsch-F\u00f6rderung mit Deutsch als Zweitsprache (DaZ) bekommt (Seiteneinsteiger, z.B. Fl\u00fcchtlingskinder)", example="false")
    public boolean istDaZFoerderung;
    @ArraySchema(schema=@Schema(implementation=ENMSprachenfolge.class, description="Ein Array mit den Informationen zu der Sprachenfolge des Sch\u00fclers."))
    @NotNull
    public @NotNull List<@NotNull ENMSprachenfolge> sprachenfolge = new ArrayList<ENMSprachenfolge>();
    @Schema(description="Informationen zum Lernabschnitt des Sch\u00fclers in der Notendatei.", example="2")
    @NotNull
    public ENMLernabschnitt lernabschnitt = new ENMLernabschnitt();
    @ArraySchema(schema=@Schema(implementation=ENMLeistung.class, description="Ein Array mit den Informationen der Leistungsdaten des Sch\u00fclers in dem Lernabschnitt der Notendatei."))
    @NotNull
    public @NotNull List<@NotNull ENMLeistung> leistungsdaten = new ArrayList<ENMLeistung>();
    @Schema(description="Die Bemerkungen bei dem Sch\u00fcler in Bezug auf den Lernabschnitt der Notendatei.", example="Bemerkungstext.")
    public ENMLeistungBemerkungen bemerkungen = new ENMLeistungBemerkungen();
    @Schema(description="Die Informationen zu den Zentralen Pr\u00fcfungen Klasse 10, sofern vorhanden - ansonsten null.", example="null")
    public ENMZP10 zp10;
    @Schema(description="Die Informationen zu den Abschl\u00fcssen am Berufskolleg, sofern vorhanden - ansonsten null.", example="null")
    public ENMBKAbschluss bkabschluss;
}

