/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.fach;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Bilingualen Sprachf\u00e4cher.")
@TranspilerDTO
public class BilingualeSpracheKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das einstellige K\u00fcrzel der Fremdsprache", example="S")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die K\u00fcrzel der Schulformen, wo die Sprache als bilinguale Fremdsprache zul\u00e4ssig ist.")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public BilingualeSpracheKatalogEintrag() {
    }

    public BilingualeSpracheKatalogEintrag(long id, @NotNull ZulaessigesFach fach, @NotNull @NotNull List<@NotNull Schulform> schulformen, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = fach.daten.kuerzel;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

