/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.fach;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.data.schule.SchulformSchulgliederung;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.fach.Fachgruppe;
import de.svws_nrw.core.types.jahrgang.Jahrgaenge;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der F\u00e4cher.")
@TranspilerDTO
public class FachKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das eindeutige K\u00fcrzel des Faches entsprechend der Vorgaben der amtlichen Schulstatistik", example="S0")
    @NotNull
    public String kuerzelASD = "";
    @Schema(description="die texttuelle Beschreibung des Faches", example="Fach Spanisch, regul\u00e4rer Beginn in der Einf\u00fchrungsphase")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="das atomare K\u00fcrzel des Faches (z.B. bei Fremdsprachen - f\u00fcr das Sprachenk\u00fcrzel) - Teil des K\u00fcrzels f\u00fcr die amtliche Schulstatistik", example="S")
    @NotNull
    public String kuerzel = "";
    @Schema(description="das Aufgabenfeld, welchem das Fach ggf. zugeordnet ist (1, 2 oder 3)", example="1")
    public Integer aufgabenfeld = -1;
    @Schema(description="das K\u00fcrzel der zugeordneten Fachgruppe", example="FS")
    public String fachgruppe = "";
    @Schema(description="der ASD-Jahrgang, ab dem das Fach zul\u00e4ssig ist (z.B. bei Fremdsprachen) - Teil des K\u00fcrzels f\u00fcr die amtliche Schulstatistik", example="EF")
    public String abJahrgang = "";
    @Schema(description="gibt an, ob es sich um eine Fremdsprache handelt", example="true")
    public boolean istFremdsprache = false;
    @Schema(description="gibt an, ob es sich um ein Fach der Herkuntftsprache handelt (Unterrichts in der Herkunftssprache oder Herkunftssprache anstelle einer Pflichtfremdsprache)", example="false")
    public boolean istHKFS = false;
    @Schema(description="gibt an, ob das Fach au\u00dferhalb des regul\u00e4ren Fachunterichts unterrichtet wird", example="false")
    public boolean istAusRegUFach = false;
    @Schema(description="gibt an, ob es sich bei dem Fach um einen Ersatz f\u00fcr eine Pflichtfremdsprache handelt (siehe auch istHKFS)", example="false")
    public boolean istErsatzPflichtFS = false;
    @Schema(description="gibt an, ob das Religionsfach konfessionell kooperativ unterrichtet wird oder nicht - Teil des K\u00fcrzels f\u00fcr die amtliche Schulstatistik", example="false")
    public boolean istKonfKoop = false;
    @Schema(description="gibt an, ob das Fach nur in der Sekundarstufe II unterrichtet wird", example="true")
    public boolean nurSII = false;
    @Schema(description="gibt an, ob das Fach bei Export der amtlichen Schulstatistik ber\u00fccksichtigt werden soll oder nicht", example="true")
    public boolean exportASD = false;
    @Schema(description="die Informationen zu Schulformen und -gliederungen, wo das Fach zul\u00e4ssig ist.")
    @NotNull
    public @NotNull List<@NotNull SchulformSchulgliederung> zulaessig = new ArrayList<SchulformSchulgliederung>();
    @Schema(description="gibt an, in welchem die Kursart einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem die Kursart g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public FachKatalogEintrag() {
    }

    public FachKatalogEintrag(long id, @NotNull String kuerzelASD, @NotNull String bezeichnung, @NotNull String kuerzel, Integer aufgabenfeld, Fachgruppe fachgruppe, Jahrgaenge abJahrgang, boolean istFremdsprache, boolean istHKFS, boolean istAusRegUFach, boolean istErsatzPflichtFS, boolean istKonfKoop, boolean nurSII, boolean exportASD, @NotNull @NotNull List<@NotNull Pair<@NotNull Schulform, Schulgliederung>> zulaessig, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzelASD = kuerzelASD;
        this.bezeichnung = bezeichnung;
        this.kuerzel = kuerzel;
        this.aufgabenfeld = aufgabenfeld;
        this.fachgruppe = fachgruppe == null ? null : fachgruppe.daten.kuerzel;
        this.abJahrgang = abJahrgang == null ? null : abJahrgang.daten.kuerzel;
        this.istFremdsprache = istFremdsprache;
        this.istHKFS = istHKFS;
        this.istAusRegUFach = istAusRegUFach;
        this.istErsatzPflichtFS = istErsatzPflichtFS;
        this.istKonfKoop = istKonfKoop;
        this.nurSII = nurSII;
        this.exportASD = exportASD;
        for (Pair<Schulform, Schulgliederung> zul : zulaessig) {
            SchulformSchulgliederung sfsgl = new SchulformSchulgliederung();
            @NotNull Schulform sf = (Schulform)((Object)zul.a);
            if (sf.daten == null) continue;
            sfsgl.schulform = sf.daten.kuerzel;
            Schulgliederung sgl = (Schulgliederung)((Object)zul.b);
            sfsgl.gliederung = sgl == null || sgl.daten == null ? null : sgl.daten.kuerzel;
            this.zulaessig.add(sfsgl);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

