/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.fach;

import de.svws_nrw.core.data.RGBFarbe;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der F\u00e4chergruppen.")
@TranspilerDTO
public class FachgruppenKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="10")
    public long id = -1L;
    @Schema(description="die Nummer f\u00fcr den Fachbereich, sofern festgelegt, ansonsten null", example="8")
    public Integer nummer = null;
    @Schema(description="die alte Fachgruppen-ID, welche in Schild_NRW 2.x verwendet wurde", example="200")
    public Integer idSchild = null;
    @Schema(description="die Bezeichnung der Fachgruppe", example="Naturwissenschaften")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="das K\u00fcrzel der Fachgruppe", example="NW")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Farbe, welche der Fachgruppe zugeordnet wurde.", example="{ \"red\": 141, \"green\": 180, \"blue\": 227 }")
    @NotNull
    public RGBFarbe farbe = new RGBFarbe();
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen die Fachgruppe vorkommt")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="ein Zahlwert, welche eine Sortier-Reihenfolge der Fachgruppen angibt (aus Schild 2.x)", example="10")
    @NotNull
    public Integer sortierung = 0;
    @Schema(description="gibt an, ob die Fachgruppe f\u00fcr die Unterteilung auf Zeugnissen genutzt wird oder nicht", example="true")
    public boolean fuerZeugnis = false;
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigBis = null;

    public FachgruppenKatalogEintrag() {
    }

    public FachgruppenKatalogEintrag(long id, Integer nummer, Integer idSchild, @NotNull String bezeichnung, @NotNull String kuerzel, @NotNull RGBFarbe farbe, @NotNull @NotNull List<@NotNull Schulform> schulformen, @NotNull Integer sortierung, boolean fuerZeugnis, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.nummer = nummer;
        this.idSchild = idSchild;
        this.bezeichnung = bezeichnung;
        this.kuerzel = kuerzel;
        this.farbe = farbe;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.sortierung = sortierung;
        this.fuerZeugnis = fuerZeugnis;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

