/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.gost;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.svws_nrw.core.data.gost.AbiturFachbelegung;
import de.svws_nrw.core.data.schueler.Sprachendaten;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.gost.GostBesondereLernleistung;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="enth\u00e4lt die Informationen der gymnasialen Oberstufe eines Sch\u00fclers in Bezug auf das Abitur.")
@JsonPropertyOrder(value={"schuelerID", "abiturjahr", "schuljahrAbitur", "fachbelegungen", "sprachenfolge", "sprachpruefungen", "bilingualeSprache", "latinum", "kleinesLatinum", "graecum", "hebraicum", "block1FehlstundenGesamt", "block1FehlstundenUnentschuldigt", "projektKursThema", "projektkursLeitfach1Kuerzel", "projektkursLeitfach2Kuerzel", "besondereLernleistung", "besondereLernleistungNotenKuerzel", "besondereLernleistungThema", "block1AnzahlKurse", "block1DefiziteGesamt", "block1DefiziteLK", "block1PunktSummeGK", "block1PunktSummeLK", "block1PunktSummeNormiert", "block1NotenpunkteDurchschnitt", "block1Zulassung", "freiwilligerRuecktritt", "block2DefiziteGesamt", "block2DefiziteLK", "block2PunktSumme", "gesamtPunkte", "gesamtPunkteVerbesserung", "gesamtPunkteVerschlechterung", "pruefungBestanden", "note"})
@TranspilerDTO
public class Abiturdaten {
    @Schema(description="Die eindeutige ID des Sch\u00fclers.", example="4711")
    public long schuelerID;
    @Schema(description="Das Kalenderjahr, in dem der Sch\u00fcler sein Abitur ablegt bzw. ablegen wird.", example="2025")
    public int abiturjahr;
    @Schema(description="Das Schuljahr, in dem der Sch\u00fcler sein Abitur ablegt bzw. ablegen wird.", example="2024")
    public int schuljahrAbitur;
    @ArraySchema(schema=@Schema(implementation=Boolean.class, description="Gibt f\u00fcr die einzelnen Halbjahre der Oberstufe an, ob gewertete Leistungsdaten vorhanden sind oder es sich um Werte der Laufbahnplanung handelt."))
    @NotNull
    public final boolean[] bewertetesHalbjahr = new boolean[6];
    @ArraySchema(schema=@Schema(implementation=AbiturFachbelegung.class, description="Ein Array mit den Fachbelegungen in der Oberstufe."))
    @NotNull
    public final @NotNull List<@NotNull AbiturFachbelegung> fachbelegungen = new ArrayList<AbiturFachbelegung>();
    @Schema(implementation=Sprachendaten.class, description="Die Sprachenfolge und die Sprachpr\u00fcfungen des Sch\u00fclers unter Einbeziehung der Daten aus der Sekundarstufe I.")
    @NotNull
    public Sprachendaten sprachendaten = new Sprachendaten();
    @Schema(description="Das einstellige K\u00fcrzel der Sprache des bilingualen Bildungsganges, falls der Sch\u00fcler an einem solchen teilnimmt, ansonsten null.", example="E")
    public String bilingualeSprache = null;
    @Schema(defaultValue="false", description="Gibt an, ob das gro\u00dfe Latinum erworben wurde.", example="true")
    public boolean latinum = false;
    @Schema(defaultValue="false", description="Gibt an, ob das kleine Latinum erworben wurde.", example="true")
    public boolean kleinesLatinum = false;
    @Schema(defaultValue="false", description="Gibt an, ob das Graecum erworben wurde.", example="true")
    public boolean graecum = false;
    @Schema(defaultValue="false", description="Gibt an, ob das Hebraicum erworben wurde.", example="true")
    public boolean hebraicum = false;
    @Schema(defaultValue="0", description="Die Anzahl der Fehlstunden in der gesamten Qualifikationsphase.", example="0")
    public long block1FehlstundenGesamt = 0L;
    @Schema(defaultValue="0", description="Die Anzahl der unentschuldigten Fehlstunden in der gesamten Qualifikationsphase.", example="0")
    public long block1FehlstundenUnentschuldigt = 0L;
    @Schema(description="Das Projektkursthema, sofern ein Projektkurs belegt wurde.", example="Das Abitur IN NRW im Wandel der Zeit.")
    public String projektKursThema = null;
    @Schema(description="Das K\u00fcrzel des ersten Leitfaches des belegten Projektkurs, sofern einer belegt wurde.", example="M")
    public String projektkursLeitfach1Kuerzel = null;
    @Schema(description="Das K\u00fcrzel des zweiten Leitfaches des belegten Projektkurs, sofern einer belegt wurde und ein zweites Leitfach f\u00fcr diesen festgelegt wurde.", example="E")
    public String projektkursLeitfach2Kuerzel = null;
    @Schema(defaultValue="K", description="Gibt an, ob eine besondere Lernleistung vorliegt (K - keine, P - in einem Projektkurs, E - extern).", example="K")
    public String besondereLernleistung;
    @Schema(description="Gibt ggf. die Note einer externen besonderen Lernleistung an.", example="2+")
    public String besondereLernleistungNotenKuerzel;
    @Schema(description="Gibt das Thema der Besonderen Lernleistung an.", example="Besondere Lernleistungen - Etwas Besonderes f\u00fcr Besondere.")
    public String besondereLernleistungThema;
    @Schema(description="Gibt die Anzahl der Kurse in der Qualifikationsphase an.", example="38")
    public Integer block1AnzahlKurse;
    @Schema(description="Gibt die Anzahl der Gesamtdefizite in der Qualifikationsphase an.", example="4")
    public Integer block1DefiziteGesamt;
    @Schema(description="Gibt die Anzahl der Defizite im LK-Bereich in der Qualifikationsphase an.", example="1")
    public Integer block1DefiziteLK;
    @Schema(description="Gibt die Punktsumme aller Grundkurse in der Qualifikationsphase an.", example="157")
    public Integer block1PunktSummeGK;
    @Schema(description="Gibt die Punktsumme aller Leistungskurse in der Qualifikationsphase an.", example="117")
    public Integer block1PunktSummeLK;
    @Schema(description="Gibt die normierte Punktsumme aller Kurse in der Qualifikationsphase an.", example="276")
    public Integer block1PunktSummeNormiert;
    @Schema(description="Gibt den Durchschnitt der Notenpunkte von allen Kursen der Qualifikationsphase an.", example="11.25")
    public Double block1NotenpunkteDurchschnitt;
    @Schema(description="Gibt an, ob die Zulassung erreicht wurde oder nicht - sofern diese schon gepr\u00fcft wurde.", example="true")
    public Boolean block1Zulassung;
    @Schema(defaultValue="false", description="Gibt an, ob freiwillig von der Abiturpr\u00fcfung zur\u00fcckgetreten wurde.", example="true")
    public boolean freiwilligerRuecktritt;
    @Schema(description="Gibt die Anzahl der Gesamtdefizite im Abiturbereich (Block II) an.", example="2")
    public Integer block2DefiziteGesamt;
    @Schema(description="Gibt die Anzahl der Leistungskurs-Defizite im Abiturbereich (Block II) an.", example="1")
    public Integer block2DefiziteLK;
    @Schema(description="Gibt die Punktsumme im Abiturbereich (Block II) an.", example="120")
    public Integer block2PunktSumme;
    @Schema(description="Gibt die erreichte Gesamtpunktzahl in der Qualifikation und im Abiturbereich (Block I und II) an.", example="456")
    public Integer gesamtPunkte;
    @Schema(description="Gibt die Gesamtpunktzahl an, ab der sich die Abiturnote verbessern w\u00fcrde.", example="463")
    public Integer gesamtPunkteVerbesserung;
    @Schema(description="Gibt die Gesamtpunktzahl an, ab der sich die Abiturnote verschlechtern w\u00fcrde.", example="444")
    public Integer gesamtPunkteVerschlechterung;
    @Schema(description="Gibt an, ob die Abiturpr\u00fcfung bestanden wurde oder nicht - sofern das Pr\u00fcfungsverfahren schon abgeschlossen wurde.", example="true")
    public Boolean pruefungBestanden;
    @Schema(description="Die Abiturnote einer bestandenen Abiturpr\u00fcfung - sofern das Pr\u00fcfungsverfahren schon abgeschlossen wurde.", example="3,1")
    public String note;

    public Abiturdaten() {
        this.besondereLernleistung = GostBesondereLernleistung.KEINE.kuerzel;
        this.besondereLernleistungNotenKuerzel = null;
        this.besondereLernleistungThema = null;
        this.block1AnzahlKurse = null;
        this.block1DefiziteGesamt = null;
        this.block1DefiziteLK = null;
        this.block1PunktSummeGK = null;
        this.block1PunktSummeLK = null;
        this.block1PunktSummeNormiert = null;
        this.block1NotenpunkteDurchschnitt = null;
        this.block1Zulassung = null;
        this.freiwilligerRuecktritt = false;
        this.block2DefiziteGesamt = null;
        this.block2DefiziteLK = null;
        this.block2PunktSumme = null;
        this.gesamtPunkte = null;
        this.gesamtPunkteVerbesserung = null;
        this.gesamtPunkteVerschlechterung = null;
        this.pruefungBestanden = null;
        this.note = null;
    }
}

