/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.gost;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Schema(description="Die Informationen zu einer an der Schule unzul\u00e4ssigen oder erforderlichen Fachkombination. Diese kann ggf. auch Kursart-spezifisch sein.")
@TranspilerDTO
public class GostJahrgangFachkombination {
    @Schema(description="die ID der Fachkombination", example="42")
    public long id;
    @Schema(description="das Jahr, in welchem der Jahrgang Abitur machen wird oder -1, falls es sich um die Vorlage f\u00fcr neue Jahrg\u00e4nge handelt", example="2042")
    public int abiturjahr;
    @Schema(description="die ID des Faches, dessen Wahl die Kombination mit einem anderen Fach verlangt oder ausschlie\u00dft", example="16")
    public long fachID1;
    @Schema(description="die Kursart der Fachwahl von Fach 1, falls die Fachkombination auf diese Kursart bei Fach 1 eingeschr\u00e4nkt ist", example="LK")
    public String kursart1;
    @Schema(description="die ID des Faches, welches in der Kombination verlangt oder ausgeschlossen wird", example="17")
    public long fachID2;
    @Schema(description="die Kursart der Fachwahl von Fach 2, falls die Fachkombination auf diese Kursart bei Fach 2 eingeschr\u00e4nkt ist", example="LK")
    public String kursart2;
    @ArraySchema(schema=@Schema(implementation=Boolean.class, description="gibt an, ob f\u00fcr die jeweilige Halbjahre der Oberstufe die Fachkombination gilt (0 = EF.1, 1=EF.2, ...)"))
    @NotNull
    public boolean[] gueltigInHalbjahr = new boolean[6];
    @Schema(description="der Typ der Fachkombination (0: Wahl von Fach 2 ist in Kombination mit Fach 1 unzul\u00e4ssig, 1: Wahl von Fach 2 ist bei Wahl von Fach 1 n\u00f6tig)", example="1")
    public int typ;
    @Schema(description="der erl\u00e4uternde Hinweistext zu der Fachkombination", example="Der Sport-Leistungskurs ist an dieser Schule nur in Verbindung mit einem Mathematik-Leistungskurs w\u00e4hlbar.")
    @NotNull
    public String hinweistext = "";
}

