/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.gost;

import de.svws_nrw.core.data.gost.GostBeratungslehrer;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="GostJahrgangsdaten")
@Schema(description="Die Daten eines Jahrgangs der gymnasialen Oberstufe.")
@TranspilerDTO
public class GostJahrgangsdaten {
    @Schema(description="das Jahr, in welchem der Jahrgang Abitur machen wird oder -1 f\u00fcr die Vorlage f\u00fcr einen neuen Abiturjahrgang", example="2042")
    public int abiturjahr;
    @Schema(description="die aktuelle Jahrgangstufe, welche dem Abiturjahrgang zugeordnet ist", example="Q1")
    public String jahrgang;
    @Schema(description="die textuelle Bezeichnung f\u00fcr den Abiturjahrgang", example="Q1")
    public String bezeichnung;
    @Schema(description="gibt an, ob das Abitur f\u00fcr diesen Jahrgang bereits abgeschlossen ist, d.h. die Schule sich bereits in einem sp\u00e4teren Schuljahr befindet", example="false")
    public boolean istAbgeschlossen;
    @Schema(description="Der derzeitige Beratungstext, welcher auf einem Ausdruck eines Sch\u00fclerlaufbahnbogens f\u00fcr die gymnasiale Oberstufe gedruckt wird.", example="Wahlen zum Beginn der Q1.1")
    public String textBeratungsbogen;
    @Schema(description="Der derzeitige Text, der beim Versenden des Beartungsbogens per Mail verwendet wird.", example="Bitte Senden Sie die Beratungsdatei ausgef\u00fcllt bis sp\u00e4testens 13.4.2042 zur\u00fcck. MfG Euer Jahrgangsstufenteam")
    public String textMailversand;
    @Schema(description="Legt fest, ob ein Zusatzkurs in Geschichte angeboten wird.", example="true")
    public boolean hatZusatzkursGE = true;
    @Schema(description="Das eindeutige K\u00fcrzel des Halbjahrs, zu dem ein Zusatzkurs in Geschichte beginnt.", example="Q2.1")
    public String beginnZusatzkursGE;
    @Schema(description="Legt fest, ob ein Zusatzkurs in Sozialwissenschaften angeboten wird.", example="true")
    public boolean hatZusatzkursSW = true;
    @Schema(description="Das eindeutige K\u00fcrzel des Halbjahrs, zu dem ein Zusatzkurs in Sozialwissenschaften beginnt.", example="Q2.1")
    public String beginnZusatzkursSW;
    @ArraySchema(schema=@Schema(implementation=Boolean.class, description="gibt an, ob f\u00fcr die jeweilige Halbjahre der Oberstufe bereits eine Blockung in den Leistungsdaten persistiert wurde (0 = EF.1, 1=EF.2, ...)"))
    @NotNull
    public boolean[] istBlockungFestgelegt = new boolean[6];
    @ArraySchema(schema=@Schema(implementation=GostBeratungslehrer.class))
    @NotNull
    public final @NotNull List<@NotNull GostBeratungslehrer> beratungslehrer = new ArrayList<GostBeratungslehrer>();
}

