/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.gost;

import de.svws_nrw.core.data.gost.GostBeratungslehrer;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.GostJahrgangFachkombination;
import de.svws_nrw.core.data.gost.GostLaufbahnplanungDatenSchueler;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Enth\u00e4lt die Informationen zum Export von Laufbahnplanungs-Daten zu einem Abiturjahrgang der gymnasialen Oberstufe.")
@TranspilerDTO
public class GostLaufbahnplanungDaten {
    @Schema(description="die Schulnummer der Schule, welcher die Laufbahndaten zugeordnet sind", example="123456")
    public long schulNr;
    @Schema(description="die Bezeichnung 1 der Schule", example="St\u00e4dt. Gymnasium")
    @NotNull
    public String schulBezeichnung1 = "";
    @Schema(description="die Bezeichnung 2 der Schule", example="der Stadt Wuppertal")
    @NotNull
    public String schulBezeichnung2 = "";
    @Schema(description="die Bezeichnung 3 der Schule", example="")
    @NotNull
    public String schulBezeichnung3 = "";
    @Schema(description="anmerkungen zu diesen Daten", example="Exportiert am 30.2.2023")
    @NotNull
    public String anmerkungen = "";
    @Schema(description="Das Kalenderjahr, in dem der Sch\u00fcler sein Abitur ablegt bzw. ablegen wird.", example="2025")
    public int abiturjahr = -1;
    @Schema(description="die aktuelle Jahrgangstufe, welche dem Abiturjahrgang zugeordnet ist", example="Q1")
    public String jahrgang;
    @Schema(description="Der derzeitige Beratungstext, welcher auf einem Ausdruck eines Sch\u00fclerlaufbahnbogens f\u00fcr die gymnasiale Oberstufe gedruckt wird.", example="Wahlen zum Beginn der Q1.1")
    public String textBeratungsbogen;
    @Schema(description="Legt fest, ob ein Zusatzkurs in Geschichte angeboten wird.", example="true")
    public boolean hatZusatzkursGE = true;
    @Schema(description="Das eindeutige K\u00fcrzel des Halbjahrs, zu dem ein Zusatzkurs in Geschichte beginnt.", example="Q2.1")
    public String beginnZusatzkursGE;
    @Schema(description="Legt fest, ob ein Zusatzkurs in Sozialwissenschaften angeboten wird.", example="true")
    public boolean hatZusatzkursSW = true;
    @Schema(description="Das eindeutige K\u00fcrzel des Halbjahrs, zu dem ein Zusatzkurs in Sozialwissenschaften beginnt.", example="Q2.1")
    public String beginnZusatzkursSW;
    @ArraySchema(schema=@Schema(implementation=GostBeratungslehrer.class))
    @NotNull
    public final @NotNull List<@NotNull GostBeratungslehrer> beratungslehrer = new ArrayList<GostBeratungslehrer>();
    @ArraySchema(schema=@Schema(implementation=GostFach.class))
    @NotNull
    public final @NotNull List<@NotNull GostFach> faecher = new ArrayList<GostFach>();
    @ArraySchema(schema=@Schema(implementation=GostJahrgangFachkombination.class))
    @NotNull
    public final @NotNull List<@NotNull GostJahrgangFachkombination> fachkombinationen = new ArrayList<GostJahrgangFachkombination>();
    @ArraySchema(schema=@Schema(implementation=GostLaufbahnplanungDatenSchueler.class))
    @NotNull
    public final @NotNull List<@NotNull GostLaufbahnplanungDatenSchueler> schueler = new ArrayList<GostLaufbahnplanungDatenSchueler>();
}

