/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.kaoa;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.kaoa.KAOAZusatzmerkmal;
import de.svws_nrw.core.types.schule.Schulstufe;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der KAoA-Anschlussoptionen.")
@TranspilerDTO
public class KAOAAnschlussoptionEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="1")
    public long id;
    @Schema(description="das K\u00fcrzel der Anschlussoption", example="STUD")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Beschreibung der Anschlussoption", example="Hochschulstudium")
    @NotNull
    public String beschreibung = "";
    @Schema(description="Jahrgangsstufen in denen der Eintrag gemacht werden darf (SI bzw. SII)")
    @NotNull
    public @NotNull List<@NotNull String> stufen = new ArrayList<String>();
    @Schema(description="Gibt an bei welchen Anschlussvereinbarungen SBO10.7 die Optionen angezeigt werden")
    @NotNull
    public @NotNull List<@NotNull String> anzeigeZusatzmerkmal = new ArrayList<String>();
    @Schema(description="gibt an, in welchem Schuljahr der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2020")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem Schuljahr der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigBis = null;

    public KAOAAnschlussoptionEintrag() {
    }

    public KAOAAnschlussoptionEintrag(long id, @NotNull String kuerzel, @NotNull String beschreibung, @NotNull @NotNull List<@NotNull Schulstufe> stufen, @NotNull @NotNull List<@NotNull KAOAZusatzmerkmal> anzeigeZusatzmerkmal, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        for (Schulstufe stufe : stufen) {
            this.stufen.add(stufe.daten.kuerzel);
        }
        for (KAOAZusatzmerkmal m : anzeigeZusatzmerkmal) {
            this.anzeigeZusatzmerkmal.add(m.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

