/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.kaoa;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.jahrgang.Jahrgaenge;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der KAoA-Kategorien.")
@TranspilerDTO
public class KAOAKategorieEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="1")
    public long id;
    @Schema(description="das K\u00fcrzel der Kategorie", example="SBO 2")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Beschreibung der Kategorie", example="Formen der Orientierung und Beratung")
    @NotNull
    public String beschreibung = "";
    @Schema(description="Jahrgangsstufen in denen der Eintrag gemacht werden darf")
    @NotNull
    public @NotNull List<@NotNull String> jahrgaenge = new ArrayList<String>();
    @Schema(description="gibt an, in welchem Schuljahr der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2020")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem Schuljahr der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigBis = null;

    public KAOAKategorieEintrag() {
    }

    public KAOAKategorieEintrag(long id, @NotNull String kuerzel, @NotNull String beschreibung, @NotNull @NotNull List<@NotNull Jahrgaenge> jahrgaenge, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        for (Jahrgaenge j : jahrgaenge) {
            this.jahrgaenge.add(j.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

