/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.kaoa;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.kaoa.KAOAKategorie;
import de.svws_nrw.core.types.kaoa.KAOAMerkmaleOptionsarten;
import de.svws_nrw.core.types.schule.Schulgliederung;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der KAoA-Merkmale.")
@TranspilerDTO
public class KAOAMerkmalEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="1")
    public long id;
    @Schema(description="das K\u00fcrzel des Merkmals", example="SBO 2")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Beschreibung des Merkmals", example="Formen der Orientierung und Beratung")
    @NotNull
    public String beschreibung = "";
    @Schema(description="die Kategorie, welcher das Merkmal zugeordnet ist", example="Formen der Orientierung und Beratung")
    @NotNull
    public String kategorie = "";
    @Schema(description="die Optionsart des Merkmals", example="Formen der Orientierung und Beratung")
    public String optionsart = null;
    @Schema(description="die Anlagen des Berufskollegs bei denen der Eintrag gemacht werden darf")
    @NotNull
    public @NotNull List<@NotNull String> bkAnlagen = new ArrayList<String>();
    @Schema(description="gibt an, in welchem Schuljahr der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2020")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem Schuljahr der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigBis = null;

    public KAOAMerkmalEintrag() {
    }

    public KAOAMerkmalEintrag(long id, @NotNull String kuerzel, @NotNull String beschreibung, @NotNull KAOAKategorie kategorie, @NotNull KAOAMerkmaleOptionsarten optionsart, @NotNull @NotNull List<@NotNull Schulgliederung> bkAnlagen, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        this.kategorie = kategorie.daten.kuerzel;
        this.optionsart = optionsart.kuerzel;
        for (Schulgliederung gl : bkAnlagen) {
            if (gl.daten.bkAnlage == null) {
                throw new NullPointerException("Es wurde keine Gliederung des Berufskollges als Anlage angegeben.");
            }
            this.bkAnlagen.add(gl.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

