/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.kaoa;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.kaoa.KAOAMerkmal;
import de.svws_nrw.core.types.kaoa.KAOAZusatzmerkmaleOptionsarten;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der KAoA-Zusatzmerkmale.")
@TranspilerDTO
public class KAOAZusatzmerkmalEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="1")
    public long id;
    @Schema(description="das K\u00fcrzel des Zusatzmerkmals", example="SBO 2.1.1")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Beschreibung des Zusatzmerkmals", example="Schulisches individuelles Beratungsgespr\u00e4ch durchgef\u00fchrt")
    @NotNull
    public String beschreibung = "";
    @Schema(description="das Merkmal, welcher das Zusatzmerkmal zugeordnet ist", example="SBO 2.1")
    @NotNull
    public String merkmal = "";
    @Schema(description="die Optionsart des Zusatzmerkmals", example="Anschlussoption")
    public String optionsart = null;
    @Schema(description="gibt an, in welchem Schuljahr der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2020")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem Schuljahr der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigBis = null;

    public KAOAZusatzmerkmalEintrag() {
    }

    public KAOAZusatzmerkmalEintrag(long id, @NotNull String kuerzel, @NotNull String beschreibung, @NotNull KAOAMerkmal merkmal, @NotNull KAOAZusatzmerkmaleOptionsarten optionsart, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        this.merkmal = merkmal.daten.kuerzel;
        this.optionsart = optionsart.kuerzel;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

