/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.klassen;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.data.schule.SchulformSchulgliederung;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Klassenarten.")
@TranspilerDTO
public class KlassenartKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das eindeutige K\u00fcrzel der Klassenart entsprechend der Vorgaben der amtlichen Schulstatistik", example="RK")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Bezeichnung der Klassenart", example="Regelklasse")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="die Informationen zu Schulformen und -gliederungen, wo die Klassenart zul\u00e4ssig ist.")
    @NotNull
    public @NotNull List<@NotNull SchulformSchulgliederung> zulaessig = new ArrayList<SchulformSchulgliederung>();
    @Schema(description="gibt an, in welchem die Klassenart einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem die Klassenart g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public KlassenartKatalogEintrag() {
    }

    public KlassenartKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String bezeichnung, @NotNull @NotNull List<@NotNull Pair<@NotNull Schulform, Schulgliederung>> zulaessig, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.bezeichnung = bezeichnung;
        for (Pair<Schulform, Schulgliederung> zul : zulaessig) {
            SchulformSchulgliederung sfsgl = new SchulformSchulgliederung();
            @NotNull Schulform sf = (Schulform)((Object)zul.a);
            if (sf.daten == null) continue;
            sfsgl.schulform = sf.daten.kuerzel;
            Schulgliederung sgl = (Schulgliederung)((Object)zul.b);
            sfsgl.gliederung = sgl == null || sgl.daten == null ? null : sgl.daten.kuerzel;
            this.zulaessig.add(sfsgl);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

