/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.kurse;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.data.schule.SchulformSchulgliederung;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Kursarten.")
@TranspilerDTO
public class KursartKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das eindeutige K\u00fcrzel der Kursart entsprechend der Vorgaben der amtlichen Schulstatistik", example="AB3")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Nummer der Kursart entsprechend der Vorgaben der amtlichen Schulstatistik", example="71")
    @NotNull
    public String nummer = "";
    @Schema(description="die Bezeichnung der Kursart", example="3. Abiturfach")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="erg\u00e4nzende Bemerkungen zu der Kursart", example="gem\u00e4\u00df \u00a7 9 Abs. 2, 3  SchulG")
    public String bemerkungen = null;
    @Schema(description="das K\u00fcrzel einer verallgemeinerten Kursart, sofern diese angegeben ist", example="GK")
    public String kuerzelAllg = null;
    @Schema(description="die Bezeichnung der verallgemeinerter Kursart, sofern diese angegeben ist", example="Grundkurs")
    public String bezeichnungAllg = null;
    @Schema(description="gibt an, ob die Kursart in der Gymnasialen Oberstufe zul\u00e4ssig ist", example="true")
    public boolean erlaubtGOSt = false;
    @Schema(description="die Informationen zu Schulformen und -gliederungen, wo die Kursart zul\u00e4ssig ist.")
    @NotNull
    public @NotNull List<@NotNull SchulformSchulgliederung> zulaessig = new ArrayList<SchulformSchulgliederung>();
    @Schema(description="gibt an, in welchem die Kursart einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem die Kursart g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public KursartKatalogEintrag() {
    }

    public KursartKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String nummer, @NotNull String bezeichnung, String bemerkungen, String kuerzelAllg, String bezeichnungAllg, boolean erlaubtGOSt, @NotNull @NotNull List<@NotNull Pair<@NotNull Schulform, Schulgliederung>> zulaessig, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.nummer = nummer;
        this.bezeichnung = bezeichnung;
        this.bemerkungen = bemerkungen;
        this.kuerzelAllg = kuerzelAllg;
        this.bezeichnungAllg = bezeichnungAllg;
        this.erlaubtGOSt = erlaubtGOSt;
        for (Pair<Schulform, Schulgliederung> zul : zulaessig) {
            SchulformSchulgliederung sfsgl = new SchulformSchulgliederung();
            @NotNull Schulform sf = (Schulform)((Object)zul.a);
            if (sf.daten == null) continue;
            sfsgl.schulform = sf.daten.kuerzel;
            Schulgliederung sgl = (Schulgliederung)((Object)zul.b);
            sfsgl.gliederung = sgl == null || sgl.daten == null ? null : sgl.daten.kuerzel;
            this.zulaessig.add(sfsgl);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

