/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerPersonalabschnittsdatenAnrechnungsstunden;
import de.svws_nrw.core.data.lehrer.LehrerPersonalabschnittsdatenLehrerfunktion;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Die Personaldaten eines Lehrer-Eintrags.")
@TranspilerDTO
public class LehrerPersonalabschnittsdaten {
    @Schema(description="die ID des Lernabschnitts in der Datenbank", example="126784")
    public long id;
    @Schema(description="Die ID des Lehrers.", example="4711")
    public long idLehrer;
    @Schema(description="die ID des Schuljahresabschnitts, zu welchem diese Abschnittdaten geh\u00f6ren", example="42")
    public long idSchuljahresabschnitt;
    @Schema(description="Das Pflichtstundensoll des Lehrers.", example="18.5")
    public Double pflichtstundensoll;
    @Schema(description="Das Rechtsverh\u00e4ltnis unter welchem der Lehrer besch\u00e4ftigt ist (z.B. Beamter auf Lebenszeit) - siehe Statistik-Katalog.", example="L")
    public String rechtsverhaeltnis;
    @Schema(description="Die Art der Besch\u00e4ftigung (Vollzeit, Teilzeit, etc.) - siehe Statistik-Katalog.", example="T")
    public String beschaeftigungsart;
    @Schema(description="[ASD] Der Einsatzstatus (z.B. Stammschule, nur hier t\u00e4tig) - siehe Statistik-Katalog.", example="*")
    public String einsatzstatus;
    @Schema(description="Die Schulnummer der Stammschule, sofern diese abweicht.", example="168890")
    public String stammschulnummer;
    @ArraySchema(schema=@Schema(implementation=LehrerPersonalabschnittsdatenAnrechnungsstunden.class, description="Ein Array mit den allgemeinen Anrechnungsstunden, die den Abschnittsdaten des Lehrers zugeordnet sind."))
    @NotNull
    public final @NotNull List<@NotNull LehrerPersonalabschnittsdatenAnrechnungsstunden> anrechnungen = new ArrayList<LehrerPersonalabschnittsdatenAnrechnungsstunden>();
    @ArraySchema(schema=@Schema(implementation=LehrerPersonalabschnittsdatenAnrechnungsstunden.class, description="Ein Array mit den Stunden, welche Mehrarbeitsgr\u00fcnde haben, dem Pflichtstundensoll hinzuzuf\u00fcgen sind und die den Abschnittsdaten des Lehrers zugeordnet sind."))
    @NotNull
    public final @NotNull List<@NotNull LehrerPersonalabschnittsdatenAnrechnungsstunden> mehrleistung = new ArrayList<LehrerPersonalabschnittsdatenAnrechnungsstunden>();
    @ArraySchema(schema=@Schema(implementation=LehrerPersonalabschnittsdatenAnrechnungsstunden.class, description="Ein Array mit den Stunden, welche Minderarbeitsgr\u00fcnde haben, dem Pflichtstundensoll wegzunehmen sind und die den Abschnittsdaten des Lehrers zugeordnet sind."))
    @NotNull
    public final @NotNull List<@NotNull LehrerPersonalabschnittsdatenAnrechnungsstunden> minderleistung = new ArrayList<LehrerPersonalabschnittsdatenAnrechnungsstunden>();
    @ArraySchema(schema=@Schema(implementation=LehrerPersonalabschnittsdatenAnrechnungsstunden.class, description="Ein Array mit schulspezifischen-Funktionen, die einem Lehrer in dem Abschnitt der Abschnittsdaten zugeordnet sind."))
    @NotNull
    public final @NotNull List<@NotNull LehrerPersonalabschnittsdatenLehrerfunktion> funktionen = new ArrayList<LehrerPersonalabschnittsdatenLehrerfunktion>();
}

