/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerFachrichtungEintrag;
import de.svws_nrw.core.data.lehrer.LehrerLehramtEintrag;
import de.svws_nrw.core.data.lehrer.LehrerLehrbefaehigungEintrag;
import de.svws_nrw.core.data.lehrer.LehrerPersonalabschnittsdaten;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Die Personaldaten eines Lehrer-Eintrags.")
@TranspilerDTO
public class LehrerPersonaldaten {
    @Schema(description="Die ID des Lehrers.", example="4711")
    public long id;
    @Schema(description="Der vordere Teil der NRW-weit eindeutigen Ident-Nummer - setzt sich normalerweise aus Geburtsdatum und Geschlecht (3/4) zusammen, kann in Einzelf\u00e4llen aber von diesem Schema abweichen.", example="1708593")
    public String identNrTeil1;
    @Schema(description="Der hintere Teil der Ident-Nummer \u2013 wird \u00fcblicherweise NRW-weit fortlaufend vergeben.", example="")
    public String identNrTeil2SerNr;
    @Schema(description="Die Personalaktennummer des Lehrers f\u00fcr den Export zu GPC.", example="")
    public String personalaktennummer;
    @Schema(description="Die Personalnummer des LBV.", example="")
    public String lbvPersonalnummer;
    @Schema(description="Der zur Personalnummer geh\u00f6rige Verg\u00fctungsschl\u00fcssel.", example="2")
    public String lbvVerguetungsschluessel;
    @Schema(description="Das Datum, wann der Lehrer an die Schule gekommen ist.", example="1911-11-11")
    public String zugangsdatum;
    @Schema(description="Der Grund f\u00fcr den Zugang des Lehrers - siehe Statistik-Katalog.", example="WIEDER")
    public String zugangsgrund;
    @Schema(description="Das Datum, wann der Lehrer an die Schule verlassen hat.", example="1920-11-12")
    public String abgangsdatum;
    @Schema(description="Der Grund f\u00fcr den Abgang des Lehrers - siehe Statistik-Katalog.", example="RUHEST")
    public String abgangsgrund;
    @ArraySchema(schema=@Schema(implementation=LehrerPersonalabschnittsdaten.class, description="Ein Array mit den Abschnittsdaten des Lehrers zu den einzelnen Schuljahresabschnitten."))
    @NotNull
    public final @NotNull List<@NotNull LehrerPersonalabschnittsdaten> abschnittsdaten = new ArrayList<LehrerPersonalabschnittsdaten>();
    @ArraySchema(schema=@Schema(implementation=LehrerLehramtEintrag.class, description="Ein Array mit den Lehr\u00e4mtern des Lehrers."))
    @NotNull
    public final @NotNull List<@NotNull LehrerLehramtEintrag> lehraemter = new ArrayList<LehrerLehramtEintrag>();
    @ArraySchema(schema=@Schema(implementation=LehrerFachrichtungEintrag.class, description="Ein Array mit den Fachrichtungen des Lehrers."))
    @NotNull
    public final @NotNull List<@NotNull LehrerFachrichtungEintrag> fachrichtungen = new ArrayList<LehrerFachrichtungEintrag>();
    @ArraySchema(schema=@Schema(implementation=LehrerLehrbefaehigungEintrag.class, description="Ein Array mit den Lehrbef\u00e4higungen des Lehrers."))
    @NotNull
    public final @NotNull List<@NotNull LehrerLehrbefaehigungEintrag> lehrbefaehigungen = new ArrayList<LehrerLehrbefaehigungEintrag>();
}

