/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schueler;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Schema(description="Ein Listeneintrag f\u00fcr die Liste der Sch\u00fcler-Lernabschnitte.")
@TranspilerDTO
public class SchuelerLernabschnittListeEintrag {
    @Schema(description="die ID des Lernabschnitts in der Datenbank", example="126784")
    public long id;
    @Schema(description="die ID des Sch\u00fclers, zu dem diese Lernabschnittdaten geh\u00f6ren", example="4785")
    public long schuelerID;
    @Schema(description="die ID des Schuljahresabschnitts, zu welchem diese Lernabschnittdaten geh\u00f6ren", example="42")
    public long schuljahresabschnitt;
    @Schema(description="Das Schuljahr, in welchem der Abschnitt liegt", example="2024")
    public int schuljahr;
    @Schema(description="Die Nummer des Abschnitts im Schuljahr", example="2")
    public int abschnitt;
    @Schema(description="eine Nr, zur Unterscheidung von Lernabschnissdaten, wenn beim Sch\u00fcler mehrere Lernabschnitt in einem Schuljahresabschnitt vorliegen (z.B. Wechsel einer Klasse, 0=aktueller Abschnitt, 1=vor dem ersten Wechsel, 2=vor dem zweiten Wechsel, usw.)", example="NULL")
    public int wechselNr = 0;
    @Schema(description="gibt an, ob es sich um einen gewerteten Abschnitt handelt oder nicht", example="true")
    public boolean istGewertet = true;
    @Schema(description="gibt an, ob es sich bei dem Abschnitt um einen wiederholten Abschnitt handelt oder nicht", example="false")
    public boolean istWiederholung = false;
    @Schema(description="die Pr\u00fcfungsordnung, die in dem Lernabschnitt bei dem Sch\u00fcler anzuwenden ist.", example="APO-GOSt(B)10/G8")
    @NotNull
    public String pruefungsOrdnung = "";
    @Schema(description="die ID der Klasse des Sch\u00fclers oder null, falls keine Klasse zugeordnet ist", example="46")
    public Long klassenID = null;
    @Schema(description="die Bezeichnung der Klasse des Sch\u00fclers", example="7a")
    @NotNull
    public String klasse = "";
    @Schema(description="die Statistik-Bezeichnung der Klasse des Sch\u00fclers", example="07A")
    @NotNull
    public String klasseStatistik = "";
    @Schema(description="die ID des Jahrgangs des Sch\u00fclers oder null, falls kein Jahrgang zugeordnet ist", example="78")
    public Long jahrgangID = null;
    @Schema(description="die Statistik-Bezeichnung des Jahrgangs des Sch\u00fclers", example="07")
    @NotNull
    public String jahrgang = "";
}

