/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schueler;

import de.svws_nrw.core.data.schueler.SchuelerLeistungsdaten;
import de.svws_nrw.core.data.schueler.SchuelerLernabschnittBemerkungen;
import de.svws_nrw.core.data.schueler.SchuelerLernabschnittNachpruefungsdaten;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Die allgemeinen Angaben zu dem Lernabschnitt eines Sch\u00fclers.")
@TranspilerDTO
public class SchuelerLernabschnittsdaten {
    @Schema(description="die ID des Lernabschnitts in der Datenbank", example="126784")
    public long id;
    @Schema(description="die ID des Sch\u00fclers, zu dem diese Lernabschnittdaten geh\u00f6ren", example="4785")
    public long schuelerID;
    @Schema(description="die ID des Schuljahresabschnitts, zu welchem diese Lernabschnittdaten geh\u00f6ren", example="42")
    public long schuljahresabschnitt;
    @Schema(description="eine Nr, zur Unterscheidung von Lernabschnissdaten, wenn beim Sch\u00fcler mehrere Lernabschnitt in einem Schuljahresabschnitt vorliegen (z.B. Wechsel einer Klasse, 0=aktueller Abschnitt, 1=vor dem ersten Wechsel, 2=vor dem zweiten Wechsel, usw.)", example="NULL")
    public int wechselNr = 0;
    @Schema(description="das Datum, wann der Lernabschnitt beginnt", example="NULL")
    public String datumAnfang = null;
    @Schema(description="das Datum, wann der Lernabschnitt endet", example="NULL")
    public String datumEnde = null;
    @Schema(description="das Datum der Konferenz", example="NULL")
    public String datumKonferenz = null;
    @Schema(description="das Datum der Zeugnisses bzw. der Laufbahnbescheinigung", example="NULL")
    public String datumZeugnis = null;
    @Schema(description="die Anzahl der Schulbesuchsjahre", example="NULL")
    public Integer anzahlSchulbesuchsjahre = null;
    @Schema(description="gibt an, ob es sich um einen gewerteten Abschnitt handelt oder nicht", example="true")
    public boolean istGewertet = true;
    @Schema(description="gibt an, ob es sich bei dem Abschnitt um einen wiederholten Abschnitt handelt oder nicht", example="false")
    public boolean istWiederholung = false;
    @Schema(description="die Pr\u00fcfungsordnung, die in dem Lernabschnitt bei dem Sch\u00fcler anzuwenden ist.", example="APO-GOSt(B)10/G8")
    @NotNull
    public String pruefungsOrdnung = "";
    @Schema(description="die ID der Klasse des Sch\u00fclers oder null, falls keine Klasse zugeordnet ist", example="46")
    public Long klassenID = null;
    @Schema(description="die ID eines Tutors, der den Sch\u00fcler betreut, oder null, falls keiner zugewiesen ist", example="null")
    public Long tutorID = null;
    @Schema(description="die ID der Folge-Klasse des Sch\u00fclers, sofern dieser vom Standard der Klassentabelle abweicht", example="59")
    public Long folgeklassenID = null;
    @Schema(description="das K\u00fcrzel der Schulgliederung bzw. des Bildungsgangs des Sch\u00fclers", example="B09")
    public String schulgliederung;
    @Schema(description="die ID des Jahrgangs des Sch\u00fclers oder null, falls kein Jahrgang zugeordnet ist", example="78")
    public Long jahrgangID = null;
    @Schema(description="die ID der Fachklasse des Sch\u00fclers an einem Berufskolleg", example="null")
    public Long fachklasseID = null;
    @Schema(description="der Schwerpunkt eines Sch\u00fclers laut dem Schwerpunkt-Katalog", example="null")
    public Long schwerpunktID = null;
    @Schema(description="das K\u00fcrzel der Organisationsform der Schule in Bezug auf den Sch\u00fcler (z.B. Ganztag)", example="null")
    public String organisationsform = null;
    @Schema(description="das K\u00fcrzel der Klassenart in Bezug auf den Sch\u00fcler (z.B. Regelklasse)", example="null")
    public String Klassenart = "RK";
    @Schema(description="die Summe der Gesamtfehlstunden f\u00fcr den gesamten Lernabschnitt", example="0")
    public int fehlstundenGesamt = 0;
    @Schema(description="die Summe der unentschuldigten Fehlstunden f\u00fcr den gesamten Lernabschnitt", example="0")
    public int fehlstundenUnentschuldigt = 0;
    @Schema(description="der Grenzwert f\u00fcr die Fehlstunden, ab dem am Berufskolleg Warnbriefe zur Entlassung verschickt werden", example="null")
    public Integer fehlstundenGrenzwert = null;
    @Schema(description="gibt an, ob eine Schwerbehinderung nachgwiesen ist oder nicht", example="false")
    public boolean hatSchwerbehinderungsNachweis = false;
    @Schema(description="gibt an, ob eine F\u00f6rderung nach der Ausbildungsordnung Sonderp\u00e4dagogischer F\u00f6rderung (AOSF) vorliegt", example="false")
    public boolean hatAOSF = false;
    @Schema(description="gibt an, ob eine Diagnose zu Autismus vorliegt oder nicht", example="false")
    public boolean hatAutismus = false;
    @Schema(description="gibt an, ob zieldifferent unterrichet wird oder nicht", example="false")
    public boolean hatZieldifferentenUnterricht = false;
    @Schema(description="die ID des Haupf\u00f6rderschwerpunktes des Sch\u00fclers", example="null")
    public Long foerderschwerpunkt1ID = null;
    @Schema(description="die ID des weiteren F\u00f6rderschwerpunktes des Sch\u00fclers", example="null")
    public Long foerderschwerpunkt2ID = null;
    @Schema(description="die ID eines Sonderp\u00e4dagogen, der den Sch\u00fcler betreut und auch im Notenmodul hat", example="null")
    public Long sonderpaedagogeID = null;
    @Schema(description="die Sprache des bilngualen Zweigs, falls der Sch\u00fcler im bilingualen Zweig unterrichtet wird", example="null")
    public String bilingualerZweig = null;
    @Schema(description="gibt f\u00fcr das Berufskolleg an, ob der fachpraktische Anteil in den Anlagen B08, B09 und B10 ausreichend sind f\u00fcr Versetzung", example="true")
    public boolean istFachpraktischerAnteilAusreichend = true;
    @Schema(description="das K\u00fcrzel des Versetzungsvermerks", example="null")
    public String versetzungsvermerk = null;
    @Schema(description="die Durchschnittsnote in diesem Lernabschnitt - wird ggf. von einem Pr\u00fcfungsalgorithmus gesetzt und kann dann ausgelesen werden", example="null")
    public String noteDurchschnitt = null;
    @Schema(description="die Lernbereichnote Gesellschaftswissenschaft oder Arbeitlehre f\u00fcr den Hauptschulabschluss nach Klassen 10", example="null")
    public Integer noteLernbereichGSbzwAL = null;
    @Schema(description="die Lernbereichnote Naturwissenschaft f\u00fcr den Hauptschulabschluss nach Klassen 10", example="null")
    public Integer noteLernbereichNW = null;
    @Schema(description="die Art des Abschlusses", example="null")
    public Integer abschlussart = null;
    @Schema(description="gibt an, ob der berechnete Abschluss eine Prognose ist oder nicht", example="false")
    public boolean istAbschlussPrognose = false;
    @Schema(description="der erreichte allgemeinbildende Abschluss", example="null")
    public String abschluss = null;
    @Schema(description="der erreichte berufsbezogene Abschluss am Berufskolleg", example="null")
    public String abschlussBerufsbildend = null;
    @Schema(description="die textuelle Ausgabe des Pr\u00fcfungsalgorithmus f\u00fcr die Versetzungs-/Abschlussberechnung", example="null")
    public String textErgebnisPruefungsalgorithmus = null;
    @Schema(description="die Art des Zeugnisses", example="null")
    public String zeugnisart = null;
    @Schema(description="die Informationen den Nachpr\u00fcfungen in diesem Lernabschnitt oder null, falls keine vorhanden sind.", example="null")
    public SchuelerLernabschnittNachpruefungsdaten nachpruefungen = null;
    @Schema(description="die Bemerkungen in diesem Lernabschnitt")
    @NotNull
    public SchuelerLernabschnittBemerkungen bemerkungen = new SchuelerLernabschnittBemerkungen();
    @ArraySchema(schema=@Schema(implementation=SchuelerLeistungsdaten.class, description="Ein Array mit den Leistungsdaten des Sch\u00fclers in diesem Lernabschnitt."))
    @NotNull
    public @NotNull List<@NotNull SchuelerLeistungsdaten> leistungsdaten = new ArrayList<SchuelerLeistungsdaten>();
}

