/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schueler;

import de.svws_nrw.core.data.schueler.SchuelerSchulbesuchMerkmal;
import de.svws_nrw.core.data.schueler.SchuelerSchulbesuchSchule;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Die Schulbesuchsdaten eines Sch\u00fcler-Eintrags.")
@TranspilerDTO
public class SchuelerSchulbesuchsdaten {
    @Schema(description="die ID", example="4711")
    public long id;
    @Schema(description="die Schulnummer der vorher besuchten Schule", example="178947")
    public String vorigeSchulnummer;
    @Schema(description="die allgemeine Herkunftsart des Sch\u00fcler in Bezug auf die schulform der zuvor besuchten Schule", example="Grundschule (auch Primarstufe der Volkschule)")
    public String vorigeAllgHerkunft;
    @Schema(description="das Entlassdatum an der zuvor besuchten Schule", example="1901-03-11")
    public String vorigeEntlassdatum;
    @Schema(description="der Entlassjahrgang an der zuvor besuchten Schule", example="03")
    public String vorigeEntlassjahrgang;
    @Schema(description="die Art der letzten Versetzung an der zuvor besuchten Schule", example="11")
    public String vorigeArtLetzteVersetzung;
    @Schema(description="die Art der letzten Versetzung an der zuvor besuchten Schule", example="diverse")
    public String vorigeBemerkung;
    @Schema(description="die ID des Grundes f\u00fcr die Entlassung von der zuvor besuchten Schule", example="2")
    public Long vorigeEntlassgrundID;
    @Schema(description="die ID des Abschlusses, welcher an der zuvor besuchten Schule erworben wurde", example="OA")
    public String vorigeAbschlussartID;
    @Schema(description="das Entlassdatum von dieser Schule", example="1902-03-11")
    public String entlassungDatum;
    @Schema(description="er Jahrgang bei der Entlassung von dieser Schule", example="03")
    public String entlassungJahrgang;
    @Schema(description="die ID des Grundes f\u00fcr die Entlassung von dieser Schule", example="1")
    public Long entlassungGrundID;
    @Schema(description="die ID des Abschlusses, welcher an dieser Schule erworben wurde", example="OA")
    public String entlassungAbschlussartID;
    @Schema(description="die Schulnummer der aufnehmenden Schule nach einer Entlassung", example="187486")
    public String aufnehmdendSchulnummer;
    @Schema(description="das Datum beim Wechsel zu einer aufnehmenden Schule", example="2020-01-01")
    public String aufnehmdendWechseldatum;
    @Schema(description="gibt an, ob die aufnehmende Schule den Wechsel best\u00e4tigt hat", example="true")
    public Boolean aufnehmdendBestaetigt;
    @Schema(description="das Jahr der Einschulung in die Grundschule", example="2005")
    public Integer grundschuleEinschulungsjahr;
    @Schema(description="die ID der Einschulungsart in die Grundschule", example="51")
    public Long grundschuleEinschulungsartID;
    @Schema(description="die Anzahl der Jahre in der Schuleingangsphase der Grundschule", example="2")
    public Integer grundschuleJahreEingangsphase;
    @Schema(description="die ID f\u00fcr die \u00dcbergangsempfehlung der Grundschule in die Sekundarstufe I", example="3")
    public Long grundschuleUebergangsempfehlungID;
    @Schema(description="das Jahr des Wechsels in die Sekundarstufe I", example="2009")
    public Integer sekIWechsel;
    @Schema(description="das K\u00fcrzel der ersten Schulform in der Sekundarstufe I", example="GY")
    public String sekIErsteSchulform;
    @Schema(description="das Jahr des Wechsels in die Sekundarstufe II", example="2017")
    public Integer sekIIWechsel;
    @ArraySchema(schema=@Schema(implementation=SchuelerSchulbesuchMerkmal.class, description="Ein Array mit den Informationen zu den besonderen Merkmalen f\u00fcr die Statistik."))
    @NotNull
    public @NotNull List<@NotNull SchuelerSchulbesuchMerkmal> merkmale = new ArrayList<SchuelerSchulbesuchMerkmal>();
    @ArraySchema(schema=@Schema(implementation=SchuelerSchulbesuchSchule.class, description="Ein Array mit den Informationen zu allen bisher besuchten Schulen."))
    @NotNull
    public @NotNull List<@NotNull SchuelerSchulbesuchSchule> alleSchulen = new ArrayList<SchuelerSchulbesuchSchule>();
}

