/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schueler;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der \u00dcbergangsempfehlungen.")
@TranspilerDTO
public class UebergangsempfehlungKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das K\u00fcrzel der Empfehlung", example="R")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Bezeichnung der \u00dcbergangsempfehlung", example="Realschule")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="der Statistikschl\u00fcssel der \u00dcbergangsempfehlung", example="10XX")
    @NotNull
    public String schluessel = "";
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigBis = null;

    public UebergangsempfehlungKatalogEintrag() {
    }

    public UebergangsempfehlungKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String bezeichnung, Schulform empfehlung, Schulform teilweise, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.bezeichnung = bezeichnung;
        if (empfehlung == null) {
            this.schluessel = "****";
        } else {
            this.schluessel = empfehlung.daten.nummer;
            this.schluessel = teilweise == null ? this.schluessel + "XX" : this.schluessel + teilweise.daten.nummer;
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

