/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der allgemeinen Merkmale.")
@TranspilerDTO
public class AllgemeineMerkmaleKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das K\u00fcrzel des allgemeinen Merkmals", example="GANZTAG")
    @NotNull
    public String kuerzel = "";
    @Schema(description="eine kurze Bezeichnung f\u00fcr das allgemeine Merkmal", example="Ganztagsschule")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="gibt an, das das Merkmal bei der Schule gesetzt werden kann", example="false")
    public boolean beiSchule = false;
    @Schema(description="gibt an, das das Merkmal bei einem Sch\u00fcler gesetzt werden kann", example="false")
    public boolean beiSchueler = false;
    @Schema(description="ggf. ein K\u00fcrzel, welches im Rahmen der amtlichen Schulstatistik verwendet wird", example="X")
    public String kuerzelASD = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen das allgemeine Merkmal vorkommen kann")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public AllgemeineMerkmaleKatalogEintrag() {
    }

    public AllgemeineMerkmaleKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String bezeichnung, boolean beiSchule, boolean beiSchueler, String kuerzelASD, @NotNull @NotNull List<@NotNull Schulform> schulformen, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.bezeichnung = bezeichnung;
        this.beiSchule = beiSchule;
        this.beiSchueler = beiSchueler;
        this.kuerzelASD = kuerzelASD;
        for (Schulform sf : schulformen) {
            this.schulformen.add(sf.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

