/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Herk\u00fcnfte aus Bildungsg\u00e4ngen an Berufskollegs.")
@TranspilerDTO
public class HerkunftBildungsgangKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das K\u00fcrzel des Bildungsganges, welches im Rahmen der amtlichen Schulstatistik verwendet wird", example="UN")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen der Bildungsgang als Herkunft vorkommen kann (BK und SB)")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="die textuelle Beschreibung des Bildungsganges", example="Berufsabschl./Hauptschulab.Kl. 10 oder mittl. Schulab. (BAB/HSA10-FOR, 3j. TZ)")
    @NotNull
    public String beschreibung = "";
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public HerkunftBildungsgangKatalogEintrag() {
    }

    public HerkunftBildungsgangKatalogEintrag(long id, @NotNull Schulgliederung gliederung, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = gliederung.daten.kuerzel;
        this.schulformen.add(Schulform.BK.daten.kuerzel);
        this.schulformen.add(Schulform.SB.daten.kuerzel);
        this.beschreibung = gliederung.daten.beschreibung;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

