/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.BerufskollegBildungsgangTyp;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.WeiterbildungskollegBildungsgangTyp;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Herk\u00fcnfte aus Typen von Bildungsg\u00e4ngen an Berufskollegs oder Weiterbildungskollegs.")
@TranspilerDTO
public class HerkunftBildungsgangTypKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das K\u00fcrzel des Bildungsgangestyps, welches im Rahmen der amtlichen Schulstatistik verwendet wird", example="AG")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen der Bildungsgang als Herkunft vorkommen kann (WB oder BK und SB)")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="die textuelle Beschreibung des Bildungsgangtyps", example="Weiterbildungskolleg: Abendgymnasium")
    @NotNull
    public String beschreibung = "";
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public HerkunftBildungsgangTypKatalogEintrag() {
    }

    public HerkunftBildungsgangTypKatalogEintrag(long id, WeiterbildungskollegBildungsgangTyp wbkTyp, BerufskollegBildungsgangTyp bkTyp, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        if (wbkTyp != null && bkTyp != null) {
            throw new IllegalArgumentException("Fehler im Core-Type: wbkTyp und bkTyp d\u00fcrfen nicht gleichzeitig gesetzt sein.");
        }
        if (wbkTyp != null) {
            this.kuerzel = wbkTyp.daten.kuerzel;
            this.schulformen.add(Schulform.WB.daten.kuerzel);
            this.beschreibung = wbkTyp.daten.bezeichnung;
        } else if (bkTyp != null) {
            this.kuerzel = bkTyp.daten.kuerzel;
            this.schulformen.add(Schulform.BK.daten.kuerzel);
            this.schulformen.add(Schulform.SB.daten.kuerzel);
            this.beschreibung = bkTyp.daten.bezeichnung;
        } else {
            throw new NullPointerException("Fehler im Core-Type. Entweder wbkTyp oder bkTyp muss gesetzt sein.");
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

