/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Herk\u00fcnfte eines Sch\u00fclers.")
@TranspilerDTO
public class HerkunftKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das der Herkunft eines Sch\u00fclers, welches im Rahmen der amtlichen Schulstatistik verwendet wird", example="UN")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen die Herkunft des Sch\u00fclers vorkommen kann")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="die textuelle Beschreibung der Herkunft", example="Herkunft noch unbekannt (nur Gliederung A12, A13)")
    @NotNull
    public String beschreibung = "";
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public HerkunftKatalogEintrag() {
    }

    public HerkunftKatalogEintrag(long id, @NotNull String kuerzel, @NotNull @NotNull List<@NotNull String> schulformen, @NotNull String beschreibung, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.schulformen = schulformen;
        this.beschreibung = beschreibung;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

