/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der m\u00f6glichen Herkunftsschulformen.")
@TranspilerDTO
public class HerkunftSchulformKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id = -1L;
    @Schema(description="das K\u00fcrzel der m\u00f6glichen Herkunftsschulform, welches im Rahmen der amtlichen Schulstatistik f\u00fcr die Schulform verwendet wird", example="SK")
    @NotNull
    public String kuerzel = "";
    @Schema(description="das K\u00fcrzel der m\u00f6glichen Herkunftsschulform, welches im Rahmen der amtlichen Schulstatistik f\u00fcr die Herkunftsschulform verwendet wird", example="SE")
    @NotNull
    public String kuerzelStatistik = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen die Herkunftsschulform vorkommen kann")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="die textuelle Beschreibung der Herkunftsschulform", example="Sekundarschule")
    @NotNull
    public String beschreibung = "";
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public HerkunftSchulformKatalogEintrag() {
    }

    public HerkunftSchulformKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String kuerzelStatistik, @NotNull @NotNull List<@NotNull Schulform> schulformen, @NotNull String beschreibung, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.kuerzelStatistik = kuerzelStatistik;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.beschreibung = beschreibung;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

